/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBMapper;
import org.eclipse.dirigible.repository.db.dao.DBObject;
import org.eclipse.dirigible.repository.db.dao.DBObjectDAO;
import org.eclipse.dirigible.repository.db.dao.DBRepositoryDAO;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBFolderDAO
extends DBObjectDAO {
    private static final String PERCENT = "%";
    private static Logger logger = Logger.getLogger(DBFolderDAO.class);

    DBFolderDAO(DBRepositoryDAO dbRepositoryDAO) {
        super(dbRepositoryDAO);
    }

    DBFolder getFolderByPath(String path) throws DBBaseException {
        logger.debug("entering getFolderByPath");
        this.checkInitialized();
        DBFolder dbFolder = null;
        DBObject dbObject = this.getObjectByPath(path);
        if (dbObject instanceof DBFolder) {
            dbFolder = (DBFolder)dbObject;
        }
        logger.debug("exiting getFolderByPath");
        return dbFolder;
    }

    DBFolder createFolder(String path) throws DBBaseException {
        logger.debug("entering createFolder");
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        StringBuffer pathBuffer = new StringBuffer();
        pathBuffer.append("/");
        DBFolder parent = null;
        DBFolder current = null;
        while (tokenizer.hasMoreTokens()) {
            pathBuffer.append(tokenizer.nextToken());
            current = this.getFolderByPath(pathBuffer.toString());
            if (current == null) {
                current = this.createSingleFolder(pathBuffer.toString(), parent);
            }
            parent = current;
            pathBuffer.append("/");
        }
        logger.debug("exiting createFolder");
        return current;
    }

    DBFolder createSingleFolder(String path, DBFolder parent) throws DBBaseException {
        logger.debug(" entering createSingleFolder");
        this.checkInitialized();
        String name = path.substring(path.lastIndexOf("/") + 1);
        String createdBy = this.getRepository().getUser();
        String modifiedBy = this.getRepository().getUser();
        this.getDbRepositoryDAO().getDbFileDAO().insertFile(name, path, "", createdBy, modifiedBy, 0);
        DBFolder dbFolder = this.getFolderByPath(path);
        logger.debug("exiting createSingleFolder");
        return dbFolder;
    }

    void removeFolderByPath(String path) throws DBBaseException {
        this.checkInitialized();
        if (!this.isFolderEmpty(path)) {
            this.removeFolderCascade(path);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_folder_by_path.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, path);
                preparedStatement.setString(2, String.valueOf(path) + "/" + PERCENT);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        this.getRepository().getCacheManager().clear(path);
    }

    private void removeFolderCascade(String path) throws DBBaseException {
        this.checkInitialized();
        this.getDbRepositoryDAO().getDbFileDAO().removeDocsCascade(path);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/remove_folder_cascade.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, String.valueOf(path) + "/" + PERCENT);
                preparedStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        this.getRepository().getCacheManager().clear();
    }

    private boolean isFolderEmpty(String path) throws DBBaseException {
        this.checkInitialized();
        boolean empty = true;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getRepository().getDbUtils().getConnection();
                String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/is_folder_empty.sql", this.getClass());
                preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
                preparedStatement.setString(1, String.valueOf(path) + "/" + PERCENT);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    empty = resultSet.getInt(1) <= 1;
                }
            }
            catch (SQLException e) {
                throw new DBBaseException(e);
            }
            catch (IOException e) {
                throw new DBBaseException(e);
            }
        }
        catch (Throwable throwable) {
            this.getRepository().getDbUtils().closeStatement(preparedStatement);
            this.getRepository().getDbUtils().closeConnection(connection);
            throw throwable;
        }
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        return empty;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DBObject> getChildrenByFolder(String path) throws DBBaseException {
        ArrayList<DBObject> arrayList;
        this.checkInitialized();
        if (path == null || "".equals(path.trim())) {
            return null;
        }
        ArrayList<DBObject> dbObjects = new ArrayList<DBObject>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getRepository().getDbUtils().getConnection();
            String script = this.getRepository().getDbUtils().readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_files_by_path.sql", this.getClass());
            preparedStatement = this.getRepository().getDbUtils().getPreparedStatement(connection, script);
            preparedStatement.setString(1, String.valueOf("/".equals(path) ? "" : path) + "/" + PERCENT);
            preparedStatement.setString(2, String.valueOf("/".equals(path) ? "" : path) + "/" + PERCENT + "/" + PERCENT);
            resultSet = preparedStatement.executeQuery();
            while (true) {
                if (!resultSet.next()) {
                    arrayList = dbObjects;
                    break;
                }
                DBObject dbObject = DBMapper.dbToObject(this.getRepository(), resultSet);
                if ("/".equals(path) && "/".equals(dbObject.getPath())) continue;
                dbObjects.add(dbObject);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBBaseException(e);
                catch (IOException e2) {
                    throw new DBBaseException(e2);
                }
            }
            catch (Throwable throwable) {
                this.getRepository().getDbUtils().closeResultSet(resultSet);
                this.getRepository().getDbUtils().closeStatement(preparedStatement);
                this.getRepository().getDbUtils().closeConnection(connection);
                throw throwable;
            }
        }
        this.getRepository().getDbUtils().closeResultSet(resultSet);
        this.getRepository().getDbUtils().closeStatement((Statement)preparedStatement);
        this.getRepository().getDbUtils().closeConnection(connection);
        return arrayList;
    }

    public void renameFolderByPath(String path, String newPath) throws DBBaseException {
        this.getDbRepositoryDAO().getDbFileDAO().renameFileByPath(path, newPath);
    }
}

