/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.dirigible.repository.ext.utils.EnvUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class ThemesServlet
extends HttpServlet {
    private static final String NAME_PARAM = "name";
    private static final String DEFAULT_THEME = "default";
    private static final String INIT_PARAM_DEFAULT_THEME = "defaultTheme";
    private static final String SLASH = "/";
    private static final long serialVersionUID = 3669759124907091014L;
    private static final Logger logger = Logger.getLogger(ThemesServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String env = EnvUtils.getEnv((String)INIT_PARAM_DEFAULT_THEME);
        String cookieValue = env == null ? DEFAULT_THEME : env;
        String them\u0435Name = req.getParameter(NAME_PARAM);
        them\u0435Name = StringEscapeUtils.escapeHtml((String)them\u0435Name);
        if ((them\u0435Name = StringEscapeUtils.escapeJavaScript((String)them\u0435Name)) != null && !them\u0435Name.isEmpty()) {
            them\u0435Name = them\u0435Name.trim();
            this.setCookieUser(resp, them\u0435Name);
            cookieValue = them\u0435Name;
        } else {
            Cookie[] cookies = req.getCookies();
            String cookieName = "dirigible_theme";
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
        }
        cookieValue = StringEscapeUtils.escapeHtml((String)cookieValue);
        cookieValue = StringEscapeUtils.escapeJavaScript((String)cookieValue);
        resp.getWriter().println(cookieValue.trim());
        resp.getWriter().flush();
        resp.getWriter().close();
    }

    private void setCookieUser(HttpServletResponse resp, String themeName) {
        Cookie cookie = new Cookie("dirigible_theme", themeName);
        cookie.setMaxAge(2592000);
        cookie.setPath(SLASH);
        resp.addCookie(cookie);
    }
}

