/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.util.Map;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IMasterRepositoryProvider;
import org.eclipse.dirigible.repository.local.ZipMasterRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public class ZipMasterRepositoryProvider
implements IMasterRepositoryProvider {
    private static final Logger logger = Logger.getLogger(ZipMasterRepositoryProvider.class);
    private static final String PARAM_USER = "user";
    private static final String PARAM_ZIP = "masterRepositoryZipLocation";
    public static final String TYPE = "zip";

    public IMasterRepository createRepository(Map<String, Object> parameters) {
        logger.debug("creating Zip Master Repository...");
        String user = (String)parameters.get(PARAM_USER);
        String zip = (String)parameters.get(PARAM_ZIP);
        if (zip == null) {
            zip = System.getProperty(PARAM_ZIP);
        }
        ZipMasterRepository zipMasterRepository = new ZipMasterRepository(user, zip);
        logger.debug("Zip Mater Repository created.");
        return zipMasterRepository;
    }

    public String getType() {
        return TYPE;
    }
}

