/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TableColumn;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class JavascriptServiceTemplateGenerator
extends TemplateGenerator {
    private static final Logger logger = Logger.getLogger(JavascriptServiceTemplateGenerator.class);
    private static final String LOG_TAG = "JAVASCRIPT_SERVICE_GENERATOR";
    private static final String PARAMETER_TABLE_NAME = "tableName";
    private static final String PARAMETER_TABLE_TYPE = "tableType";
    private static final String PARAMETER_DEPENDENT_COLUMN = "dependentColumn";
    private static final String PARAMETER_ENTITY_NAME = "entityName";
    private static final String PARAMETER_TABLE_COLUMNS = "tableColumns";
    private static final String PARAMETER_TABLE_COLUMNS_WITHOUT_KEYS = "tableColumnsWithoutKeys";
    private static final String PARAMETER_PRIMARY_KEY = "primaryKey";
    private static final String PARAMETER_INTEGER = "INTEGER";
    private static final String PARAMETER_BIGINT = "BIGINT";
    private static final String PARAMETER_SMALLINT = "SMALLINT";
    private static final String PARAMETER_FLOAT = "FLOAT";
    private static final String PARAMETER_DOUBLE = "DOUBLE";
    private static final String PARAMETER_VARCHAR = "VARCHAR";
    private static final String PARAMETER_CHAR = "CHAR";
    private static final String PARAMETER_DATE = "DATE";
    private static final String PARAMETER_TIME = "TIME";
    private static final String PARAMETER_TIMESTAMP = "TIMESTAMP";
    private static final String PARAMETER_BOOLEAN = "BOOLEAN";
    private JavascriptServiceTemplateModel model;

    public JavascriptServiceTemplateGenerator(JavascriptServiceTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        Map parameters = super.prepareParameters();
        parameters.put(PARAMETER_TABLE_NAME, this.model.getTableName());
        parameters.put(PARAMETER_TABLE_TYPE, this.model.getTableType());
        parameters.put(PARAMETER_DEPENDENT_COLUMN, this.model.getDependentColumn());
        parameters.put(PARAMETER_ENTITY_NAME, CommonUtils.toCamelCase((String)this.model.getTableName()));
        parameters.put(PARAMETER_TABLE_COLUMNS, this.model.getTableColumns());
        parameters.put(PARAMETER_TABLE_COLUMNS_WITHOUT_KEYS, this.getTableColumnsWithoutKeys(this.model.getTableColumns()));
        parameters.put(PARAMETER_PRIMARY_KEY, this.getPrimaryKey());
        parameters.put(PARAMETER_INTEGER, 4);
        parameters.put(PARAMETER_BIGINT, -5);
        parameters.put(PARAMETER_SMALLINT, 5);
        parameters.put(PARAMETER_FLOAT, 7);
        parameters.put(PARAMETER_DOUBLE, 8);
        parameters.put(PARAMETER_VARCHAR, 12);
        parameters.put(PARAMETER_CHAR, 1);
        parameters.put(PARAMETER_DATE, 91);
        parameters.put(PARAMETER_TIME, 92);
        parameters.put(PARAMETER_TIMESTAMP, 93);
        parameters.put(PARAMETER_BOOLEAN, 16);
        return parameters;
    }

    private Object getPrimaryKey() {
        if (this.model.getTableName() != null) {
            TableColumn[] columns = this.model.getTableColumns();
            TableColumn primaryKey = null;
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                if (column.isKey()) {
                    primaryKey = column;
                }
                ++n2;
            }
            if (primaryKey == null) {
                logger.error(String.format("There is no primary key in table %s, which can produce errornous artifacts", this.model.getTableName()));
                return null;
            }
            return primaryKey;
        }
        return null;
    }

    private TableColumn[] getTableColumnsWithoutKeys(TableColumn[] tableColumns) {
        if (tableColumns == null) {
            return null;
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        TableColumn[] tableColumnArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn2 = tableColumnArray[n2];
            TableColumn tableColumn = tableColumn2;
            if (!tableColumn.isKey()) {
                list.add(tableColumn);
            }
            ++n2;
        }
        return list.toArray(new TableColumn[0]);
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        return this.model.normalizeEscapes(bytes);
    }

    protected String getDefaultRootFolder() {
        return "ScriptingServices";
    }
}

