/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.is.wizard;

import java.util.Map;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateModel;

public class IntegrationServiceTemplateGenerator
extends TemplateGenerator {
    private static final String LOG_TAG = "INTEGRATION_SERVICE_GENERATOR";
    private static final String PARAMETER_ID = "id";
    private static final String PARAMETER_ENDPOINT_ADDRESS = "endpointAddress";
    private static final String PARAMETER_FILE_NAME_NO_EXTENSION_TITLE = "fileNameNoExtensionTitle";
    private IntegrationServiceTemplateModel model;

    public IntegrationServiceTemplateGenerator(IntegrationServiceTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        String fileNameNoExtension;
        Map parameters = super.prepareParameters();
        parameters.put(PARAMETER_ID, this.model.getId());
        parameters.put(PARAMETER_ENDPOINT_ADDRESS, this.model.getEndpointAddress());
        String fileNameNoExtensionTitle = fileNameNoExtension = this.model.getFileNameNoExtension();
        if (fileNameNoExtension != null && fileNameNoExtension.length() > 1) {
            char[] chars = fileNameNoExtension.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            fileNameNoExtensionTitle = new String(chars);
        }
        parameters.put(PARAMETER_FILE_NAME_NO_EXTENSION_TITLE, fileNameNoExtensionTitle);
        return parameters;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        return this.model.normalizeEscapes(bytes);
    }

    protected String getDefaultRootFolder() {
        return "IntegrationServices";
    }
}

