/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.wizard;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import javax.sql.DataSource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.db.wizard.ColumnDefinition;
import org.eclipse.dirigible.ide.template.ui.db.wizard.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.ui.common.validation.ValidationStatus;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class TableTemplateModel
extends GenerationModel {
    private static final String TABLE_OR_VIEW_WITH_THE_SAME_NAME_ALREADY_EXISTS = Messages.TableTemplateModel_TABLE_OR_VIEW_WITH_THE_SAME_NAME_ALREADY_EXISTS;
    private static final Logger logger = Logger.getLogger(TableTemplateModel.class);
    private static final String TARGET_LOCATION_IS_NOT_ALLOWED = Messages.TableTemplateModel_TARGET_LOCATION_IS_NOT_ALLOWED;
    private static final String NO_PRIMARY_KEY_FOUND = Messages.TableTemplateModel_NO_PRIMARY_KEY_FOUND;
    private static final String DUPLICATE_COLUMN_NAMES_FOUND = Messages.TableTemplateModel_DUPLICATE_COLUMN_NAMES_FOUND;
    private static final String NO_COLUMNS_DEFINED = Messages.TableTemplateModel_NO_COLUMNS_DEFINED;
    public ColumnDefinition[] columnDefinitions;

    public ColumnDefinition[] getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(ColumnDefinition[] columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
    }

    public IValidationStatus validateLocation() {
        IValidationStatus status;
        try {
            status = this.validateLocationGeneric();
            if (status.hasErrors()) {
                return status;
            }
            IPath location = new Path(this.getTargetLocation()).append(this.getFileName());
            if (location.toString().indexOf("DataStructures") == -1) {
                return ValidationStatus.createError((String)TARGET_LOCATION_IS_NOT_ALLOWED);
            }
            if (this.isTableExists(this.getFileNameNoExtension().toLowerCase()) && (this.getFileName().endsWith(".table") || this.getFileName().endsWith(".view")) || this.isTableExists(this.getFileNameNoExtension().toUpperCase()) && (this.getFileName().endsWith(".table") || this.getFileName().endsWith(".view"))) {
                return ValidationStatus.createError((String)TABLE_OR_VIEW_WITH_THE_SAME_NAME_ALREADY_EXISTS);
            }
        }
        catch (Exception exception) {
            return ValidationStatus.createError((String)"");
        }
        return status;
    }

    protected String getArtifactType() {
        return "DataStructures";
    }

    protected String getTargetLocationErrorMessage() {
        return TARGET_LOCATION_IS_NOT_ALLOWED;
    }

    private boolean isTableExists(String tableName) {
        Connection connection = null;
        try {
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(CommonIDEParameters.getRequest());
            connection = dataSource.getConnection();
            boolean bl = DBUtils.isTableOrViewExists((Connection)connection, (String)tableName);
            return bl;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    public IValidationStatus validateColumnDefinitions() {
        if (this.columnDefinitions.length <= 0) {
            return ValidationStatus.createError((String)NO_COLUMNS_DEFINED);
        }
        if (this.duplicateNames(this.columnDefinitions)) {
            return ValidationStatus.createError((String)DUPLICATE_COLUMN_NAMES_FOUND);
        }
        if (!this.thereIsPrimaryKey()) {
            return ValidationStatus.createError((String)NO_PRIMARY_KEY_FOUND);
        }
        return ValidationStatus.createOk();
    }

    private boolean duplicateNames(ColumnDefinition[] columnDefinitions) {
        HashSet<String> temp = new HashSet<String>();
        ColumnDefinition[] columnDefinitionArray = columnDefinitions;
        int n = columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n2];
            if (temp.contains(columnDefinition.getName())) {
                return true;
            }
            temp.add(columnDefinition.getName());
            ++n2;
        }
        return false;
    }

    private boolean thereIsPrimaryKey() {
        ColumnDefinition[] columnDefinitionArray = this.columnDefinitions;
        int n = this.columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition columnDefinition = columnDefinitionArray[n2];
            if (columnDefinition.isPrimaryKey()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

