/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.designer.ui;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.designer.ui.IDesignerEditorWidgetListener;
import org.eclipse.dirigible.ide.designer.ui.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DesignerEditorWidget
extends Composite {
    private static final long serialVersionUID = -8881201238299386468L;
    private static final Logger logger = Logger.getLogger(DesignerEditorWidget.class);
    private static final String SCRIPT_EVALUATION_FAILED = Messages.DesignerEditorWidget_Script_evaluation_failed;
    private static final int EVALUATE_ATTEMPTS = 5;
    private static final String EDITOR_URL = "/wysiwyg/wysiwyg.html";
    private Browser browser;
    private String text;
    private IDesignerEditorWidgetListener listener;
    private String mode;
    private boolean loaded;

    public DesignerEditorWidget(Composite parent) {
        super(parent, 0);
        super.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, 0);
        this.browser.setUrl(String.valueOf(CommonIDEParameters.getContextPath()) + EDITOR_URL);
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                DesignerEditorWidget.this.loaded = true;
                DesignerEditorWidget.this.updateWidgetContents();
            }

            public void changed(ProgressEvent event) {
            }
        });
        new BrowserFunction(this.browser, "saveCalled"){

            public Object function(Object[] arguments) {
                if (DesignerEditorWidget.this.listener != null) {
                    DesignerEditorWidget.this.listener.save();
                }
                return null;
            }
        };
        new BrowserFunction(this.browser, "dirtyChanged"){

            public Object function(Object[] arguments) {
                if (DesignerEditorWidget.this.listener != null) {
                    DesignerEditorWidget.this.listener.dirtyStateChanged((Boolean)arguments[0]);
                }
                return null;
            }
        };
    }

    public void setListener(IDesignerEditorWidgetListener listener) {
        this.listener = listener;
    }

    public void setText(String text) {
        this.text = text;
        if (this.loaded) {
            this.updateWidgetContents();
        }
    }

    public String getText() {
        return (String)this.browser.evaluate("return getEditorContent();");
    }

    public void setDirty(boolean dirty) {
        this.execute("setDirty", dirty);
    }

    private void updateWidgetContents() {
        this.evaluate("window.setEditorContent", this.text);
    }

    private void execute(String function, Object ... arguments) {
        this.browser.execute(this.buildFunctionCall(function, arguments));
    }

    private Object evaluate(String function, Object ... arguments) {
        String script = this.buildFunctionCall(function, arguments);
        return this.browser.evaluate(script);
    }

    private String buildFunctionCall(String function, Object ... arguments) {
        StringBuilder call = new StringBuilder();
        call.append(function).append('(');
        if (arguments != null) {
            Object[] objectArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object argument = objectArray[n2];
                String strArg = null;
                strArg = argument instanceof String ? this.prepareStringArgument((String)argument) : String.valueOf(argument);
                call.append(strArg).append(",");
                ++n2;
            }
            if (arguments.length > 0) {
                call.deleteCharAt(call.length() - 1);
            }
        }
        call.append(')');
        return call.toString();
    }

    private String prepareStringArgument(String argument) {
        return "'" + StringEscapeUtils.escapeJavaScript((String)argument) + "'";
    }
}

