/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.preferences;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DatabaseAttributesPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = Logger.getLogger(DatabaseAttributesPreferencePage.class);
    private static final long serialVersionUID = -877187045002896492L;

    public DatabaseAttributesPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Text text = null;
        DataSource dataSource = DataSourceFacade.getInstance().getDataSource(CommonIDEParameters.getRequest());
        Connection connection = null;
        try {
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData dmd = connection.getMetaData();
                StringFieldEditor databaseProductNameField = new StringFieldEditor("DATABASE_PRODUCT_NAME", "&Product Name:", this.getFieldEditorParent());
                text = databaseProductNameField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String productName = dmd.getDatabaseProductName();
                text.setText(productName != null ? productName : "n/a");
                this.addField((FieldEditor)databaseProductNameField);
                StringFieldEditor databaseProductVersionField = new StringFieldEditor("DATABASE_PRODUCT_VERSION", "&Product Version:", this.getFieldEditorParent());
                text = databaseProductVersionField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String productVersion = dmd.getDatabaseProductVersion();
                text.setText(productVersion != null ? productVersion : "n/a");
                this.addField((FieldEditor)databaseProductVersionField);
                StringFieldEditor databaseMinorVersionField = new StringFieldEditor("DATABASE_MINOR_VERSION", "&Minor Version:", this.getFieldEditorParent());
                text = databaseMinorVersionField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String productVersionMinor = String.valueOf(dmd.getDatabaseMinorVersion());
                text.setText(productVersionMinor);
                this.addField((FieldEditor)databaseMinorVersionField);
                StringFieldEditor databaseMajorVersionField = new StringFieldEditor("DATABASE_MAJOR_VERSION", "&Major Version:", this.getFieldEditorParent());
                text = databaseMajorVersionField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String productVersionMajor = String.valueOf(dmd.getDatabaseMajorVersion());
                text.setText(productVersionMajor);
                this.addField((FieldEditor)databaseMajorVersionField);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void init(IWorkbench workbench) {
        super.initialize();
    }
}

