/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableImporter;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class DsvUpdater
extends AbstractDataUpdater {
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String TABLE_NAME = "tableName";
    private static final String EXTENSION_TABLE = ".table";
    private static final String EXTENSION_DSV = ".dsv";
    private static final Logger logger = Logger.getLogger(DsvUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;

    public DsvUpdater(IRepository repository, DataSource dataSource, String location) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
    }

    @Override
    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_DSV)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    @Override
    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                for (String dsDefinition : knownFiles) {
                    try {
                        if (!dsDefinition.endsWith(EXTENSION_DSV)) continue;
                        this.executeDSVUpdate(connection, dsDefinition);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (errors == null) continue;
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, errors);
    }

    private void executeDSVUpdate(Connection connection, String dsDefinition) throws Exception {
        String tableName = CommonUtils.getFileNameFromRepositoryPathNoExtension(dsDefinition);
        this.deleteAllDataFromTable(tableName);
        IResource resource = this.repository.getResource(dsDefinition);
        byte[] content = resource.getContent();
        if (content.length != 0) {
            DBTableImporter tableDataInserter = new DBTableImporter(this.dataSource, content, String.valueOf(tableName) + EXTENSION_TABLE);
            tableDataInserter.insert();
        }
    }

    private JsonObject parseTable(String dsDefinition) throws IOException {
        IResource resource = this.repository.getResource(dsDefinition);
        String content = new String(resource.getContent());
        JsonParser parser = new JsonParser();
        JsonObject dsDefinitionObject = (JsonObject)parser.parse(content);
        return dsDefinitionObject;
    }

    private void deleteAllDataFromTable(String tableName) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            PreparedStatement deleteStatement = con.prepareStatement(DELETE_FROM + tableName);
            deleteStatement.execute();
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

