/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.create;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.dirigible.ide.common.image.ImageUtils;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.NewProjectWizardModel;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.ProjectTemplateType;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.ProjectTemplateTypePageLabelProvider;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewProjectWizardTemplateTypePage
extends WizardPage {
    private static final long serialVersionUID = -2312000617075348922L;
    private static final String ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION = Messages.NewProjectWizardTemplateTypePage_ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION;
    private static final String SELECT_TEMPLATE_TYPE_FORM_THE_LIST = Messages.NewProjectWizardTemplateTypePage_SELECT_TEMPLATE_TYPE_FORM_THE_LIST;
    private static final String PAGE_NAME = Messages.NewProjectWizardTemplateTypePage_PAGE_NAME;
    private static final String PAGE_TITLE = Messages.NewProjectWizardTemplateTypePage_PAGE_TITLE;
    private static final String PAGE_DESCRIPTION = Messages.NewProjectWizardTemplateTypePage_PAGE_DESCRIPTION;
    private static final Logger logger = Logger.getLogger(NewProjectWizardTemplateTypePage.class);
    private final NewProjectWizardModel model;
    private TableViewer typeViewer;
    private Label labelPreview;
    private static final Image previewImage = ImageUtils.createImage((URL)NewProjectWizardTemplateTypePage.getIconURL("preview.png"));

    public NewProjectWizardTemplateTypePage(NewProjectWizardModel model) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createTypeField(composite);
        this.createPreviewLabel(composite);
        this.checkPageStatus();
    }

    public static URL getIconURL(String iconName) {
        URL url = ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.workspace.wizard.project", (String)"/icons/", (String)iconName);
        return url;
    }

    private void createPreviewLabel(Composite composite) {
        this.labelPreview = new Label(composite, 0);
        this.labelPreview.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.labelPreview.setBounds(0, 0, 450, 300);
        this.labelPreview.setBackground(new Color(null, 0, 0, 0));
        this.labelPreview.setImage(previewImage);
    }

    private void createTypeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.NewProjectWizardTemplateTypePage_AVAILABLE_TEMPLATES);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.typeViewer = new TableViewer(parent, 2564);
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new ProjectTemplateTypePageLabelProvider());
        ProjectTemplateType[] templateTypes = this.createTemplateTypes();
        this.typeViewer.setInput((Object)templateTypes);
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() == null || !(selection.getFirstElement() instanceof ProjectTemplateType)) {
                    NewProjectWizardTemplateTypePage.this.setErrorMessage(SELECT_TEMPLATE_TYPE_FORM_THE_LIST);
                    NewProjectWizardTemplateTypePage.this.setPageComplete(false);
                    NewProjectWizardTemplateTypePage.this.labelPreview.setImage(previewImage);
                    NewProjectWizardTemplateTypePage.this.labelPreview.pack(true);
                    return;
                }
                NewProjectWizardTemplateTypePage.this.setErrorMessage(null);
                ProjectTemplateType templateType = (ProjectTemplateType)selection.getFirstElement();
                NewProjectWizardTemplateTypePage.this.getModel().setTemplate(templateType);
                NewProjectWizardTemplateTypePage.this.labelPreview.setImage(templateType.getImagePreview());
                NewProjectWizardTemplateTypePage.this.labelPreview.pack(true);
                NewProjectWizardTemplateTypePage.this.checkPageStatus();
            }
        });
    }

    private ProjectTemplateType[] createTemplateTypes() {
        try {
            ProjectTemplateType[] templateTypes = this.prepareTemplateTypes();
            return templateTypes;
        }
        catch (IOException e) {
            logger.error(ERROR_ON_LOADING_TEMPLATES_FOR_GENERATION, (Throwable)e);
            return null;
        }
    }

    protected ProjectTemplateType[] prepareTemplateTypes() throws IOException {
        ArrayList<ProjectTemplateType> projectTemplateTypesList = new ArrayList<ProjectTemplateType>();
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection projectTemplatesRoot = repository.getCollection("/db/dirigible/templates/Projects/");
        if (!projectTemplatesRoot.exists()) {
            this.model.setUseTemplate(false);
            return new ProjectTemplateType[0];
        }
        for (ICollection projectCollection : projectTemplatesRoot.getCollections()) {
            try {
                projectTemplateTypesList.add(ProjectTemplateType.createTemplateType(repository, projectCollection.getPath()));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return projectTemplateTypesList.toArray(new ProjectTemplateType[0]);
    }

    private void checkPageStatus() {
        if (this.getModel().isUseTemplate() && (this.getModel().getTemplateLocation() == null || "".equals(this.getModel().getTemplateLocation()))) {
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    public NewProjectWizardModel getModel() {
        return this.model;
    }
}

