/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.nashorn;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.runtime.js.nashorn.ISourceProvider;
import org.eclipse.dirigible.runtime.scripting.IBaseScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.Messages;

public class NashornRepositoryModuleSourceProvider
implements ISourceProvider {
    private static final long serialVersionUID = -5527033249080497877L;
    private static final String MODULE_LOCATION_CANNOT_BE_NULL = Messages.getString((String)"ScriptLoader.MODULE_LOCATION_CANNOT_BE_NULL");
    private static final String JS_EXTENSION = ".js";
    private static final String JSLIB_EXTENSION = ".js";
    private IBaseScriptExecutor executor;
    private IRepository repository;
    private String[] rootPaths;

    public NashornRepositoryModuleSourceProvider(IBaseScriptExecutor executor, IRepository repository, String ... rootPaths) {
        this.executor = executor;
        this.repository = repository;
        this.rootPaths = rootPaths;
    }

    @Override
    public String loadSource(String moduleId) throws IOException, URISyntaxException {
        if (moduleId == null) {
            throw new IOException(MODULE_LOCATION_CANNOT_BE_NULL);
        }
        byte[] sourceCode = null;
        sourceCode = moduleId.endsWith(".js") ? this.executor.retrieveModule(this.repository, moduleId, "", this.rootPaths).getContent() : this.executor.retrieveModule(this.repository, moduleId, ".js", this.rootPaths).getContent();
        return new String(sourceCode);
    }
}

