/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scripting;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.extensions.ExtensionManager;
import org.eclipse.dirigible.repository.ext.extensions.IExtensionService;
import org.eclipse.dirigible.repository.ext.messaging.IMessagingService;
import org.eclipse.dirigible.repository.ext.messaging.MessageHub;
import org.eclipse.dirigible.repository.ext.template.ITemplatingService;
import org.eclipse.dirigible.repository.ext.template.TemplatingEngine;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.RuntimeActivator;
import org.eclipse.dirigible.runtime.mail.MailServiceFactory;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.Console;
import org.eclipse.dirigible.runtime.scripting.IBaseScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IContextService;
import org.eclipse.dirigible.runtime.scripting.IMailService;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.InjectedAPIBuilder;
import org.eclipse.dirigible.runtime.scripting.InjectedAPIWrapper;
import org.eclipse.dirigible.runtime.scripting.Messages;
import org.eclipse.dirigible.runtime.scripting.Module;
import org.eclipse.dirigible.runtime.scripting.utils.ConfigStorageUtils;
import org.eclipse.dirigible.runtime.scripting.utils.ConnectivityConfigurationUtils;
import org.eclipse.dirigible.runtime.scripting.utils.DbUtils;
import org.eclipse.dirigible.runtime.scripting.utils.ExceptionUtils;
import org.eclipse.dirigible.runtime.scripting.utils.ExecutionService;
import org.eclipse.dirigible.runtime.scripting.utils.FileStorageUtils;
import org.eclipse.dirigible.runtime.scripting.utils.HttpUtils;
import org.eclipse.dirigible.runtime.scripting.utils.IndexingService;
import org.eclipse.dirigible.runtime.scripting.utils.NamedDataSourcesUtils;
import org.eclipse.dirigible.runtime.scripting.utils.StorageUtils;
import org.eclipse.dirigible.runtime.scripting.utils.URLUtils;
import org.eclipse.dirigible.runtime.scripting.utils.XMLUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class AbstractScriptExecutor
implements IScriptExecutor,
IBaseScriptExecutor {
    private static final String THERE_IS_NO_RESOURCE_AT_THE_SPECIFIED_SERVICE_PATH = Messages.getString("ScriptLoader.THERE_IS_NO_RESOURCE_AT_THE_SPECIFIED_SERVICE_PATH");
    private static final String THERE_IS_NO_COLLECTION_AT_THE_SPECIFIED_SERVICE_PATH = Messages.getString("ScriptLoader.THERE_IS_NO_COLLECTION_AT_THE_SPECIFIED_SERVICE_PATH");
    private static final Logger logger = Logger.getLogger(AbstractScriptExecutor.class);

    @Override
    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext) throws IOException {
        return this.executeServiceModule(request, response, request == null ? null : request.getInputStream(), module, executionContext);
    }

    protected abstract Object executeServiceModule(HttpServletRequest var1, HttpServletResponse var2, Object var3, String var4, Map<Object, Object> var5) throws IOException;

    protected abstract void registerDefaultVariable(Object var1, String var2, Object var3);

    private void registerDefaultVariableInContextAndScope(Map<Object, Object> executionContext, Object scope, String name, Object value) {
        if (executionContext.get(name) == null) {
            this.registerDefaultVariable(scope, name, value);
            executionContext.put(name, value);
        }
    }

    @Override
    public void registerDefaultVariables(HttpServletRequest request, HttpServletResponse response, Object input, Map<Object, Object> executionContext, IRepository repository, Object scope) {
        InjectedAPIBuilder apiBuilder = new InjectedAPIBuilder();
        if (executionContext == null) {
            executionContext = new HashMap<Object, Object>();
        }
        this.registerDefaultVariable(scope, "context", executionContext);
        apiBuilder.setExecutionContext(executionContext);
        Console console = new Console();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "console", console);
        apiBuilder.setConsole(console);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "out", System.out);
        apiBuilder.setSystemOutput(System.out);
        DataSource dataSource = null;
        dataSource = this.registerDefaultDatasource(request, executionContext, scope, apiBuilder);
        this.registerRequest(request, executionContext, scope, apiBuilder);
        this.registerResponse(response, executionContext, scope, apiBuilder);
        this.registerRepository(executionContext, repository, scope, apiBuilder);
        this.registerUserName(request, executionContext, scope, apiBuilder);
        this.registerRequestInput(input, executionContext, scope, apiBuilder);
        this.registerInitialContext(request, executionContext, scope, apiBuilder);
        this.registerBinaryStorage(executionContext, scope, apiBuilder, dataSource);
        this.registerFileStorage(executionContext, scope, apiBuilder, dataSource);
        this.registerConfigurationStorage(executionContext, scope, apiBuilder, dataSource);
        this.registerMailService(request, executionContext, scope, apiBuilder);
        this.registerExtensionManager(request, executionContext, repository, scope, apiBuilder, dataSource);
        this.registerIndexingService(executionContext, scope, apiBuilder);
        this.registerConnectivityService(executionContext, scope, apiBuilder);
        this.registerMessagingService(request, executionContext, scope, apiBuilder, dataSource);
        this.registerTemplatingService(executionContext, scope, apiBuilder);
        this.registerExecutingService(executionContext, scope, apiBuilder);
        IOUtils ioUtils = new IOUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "io", ioUtils);
        apiBuilder.setIOUtils(ioUtils);
        HttpUtils httpUtils = new HttpUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "http", httpUtils);
        apiBuilder.setHttpUtils(httpUtils);
        Base64 base64Codec = new Base64();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "base64", base64Codec);
        apiBuilder.setBase64Utils(base64Codec);
        Hex hexCodec = new Hex();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "hex", hexCodec);
        apiBuilder.setHexUtils(hexCodec);
        DigestUtils digestUtils = new DigestUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "digest", digestUtils);
        apiBuilder.setDigestUtils(digestUtils);
        URLUtils urlUtils = new URLUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "url", urlUtils);
        apiBuilder.setUrlUtils(urlUtils);
        ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "upload", fileUpload);
        apiBuilder.setUploadUtils(fileUpload);
        UUID uuid = new UUID(0L, 0L);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "uuid", uuid);
        apiBuilder.setUuidUtils(uuid);
        DbUtils dbUtils = new DbUtils(dataSource);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "db", dbUtils);
        apiBuilder.setDatabaseUtils(dbUtils);
        StringEscapeUtils stringEscapeUtils = new StringEscapeUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "xss", stringEscapeUtils);
        apiBuilder.setXssUtils(stringEscapeUtils);
        XMLUtils xmlUtils = new XMLUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "xml", xmlUtils);
        apiBuilder.setXmlUtils(xmlUtils);
        ExceptionUtils exceptionUtils = new ExceptionUtils();
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "exception", exceptionUtils);
        apiBuilder.setExceptionUtils(exceptionUtils);
        NamedDataSourcesUtils namedDataSourcesUtils = new NamedDataSourcesUtils(request);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "datasources", namedDataSourcesUtils);
        apiBuilder.setNamedDataSourcesUtils(namedDataSourcesUtils);
        try {
            BundleContext context = RuntimeActivator.getContext();
            if (context != null) {
                Collection serviceReferences = context.getServiceReferences(IContextService.class, null);
                for (ServiceReference serviceReference : serviceReferences) {
                    try {
                        IContextService contextService = (IContextService)context.getService(serviceReference);
                        this.registerDefaultVariableInContextAndScope(executionContext, scope, contextService.getName(), contextService.getInstance());
                        apiBuilder.set(contextService.getName(), contextService.getInstance());
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        InjectedAPIWrapper api = new InjectedAPIWrapper(apiBuilder);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "$", api);
    }

    protected void registerTemplatingService(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            TemplatingEngine templatingEngine = new TemplatingEngine();
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "templatingEngine", templatingEngine);
            apiBuilder.setTemplatingService((ITemplatingService)templatingEngine);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerExecutingService(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            ExecutionService executionService = new ExecutionService();
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "exec", executionService);
            apiBuilder.setExecutionService(executionService);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerMessagingService(HttpServletRequest request, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder, DataSource dataSource) {
        try {
            MessageHub messageHub = new MessageHub(dataSource, request);
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "messageHub", messageHub);
            apiBuilder.setMessagingService((IMessagingService)messageHub);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerConnectivityService(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            ConnectivityConfigurationUtils configurationUtils = new ConnectivityConfigurationUtils();
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "connectivity", configurationUtils);
            apiBuilder.setConnectivityService(configurationUtils);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerIndexingService(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            IndexingService indexingUtils = new IndexingService();
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "indexer", indexingUtils);
            apiBuilder.setIndexingService(indexingUtils);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerExtensionManager(HttpServletRequest request, Map<Object, Object> executionContext, IRepository repository, Object scope, InjectedAPIBuilder apiBuilder, DataSource dataSource) {
        try {
            ExtensionManager extensionManager = new ExtensionManager(repository, dataSource, request);
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "extensionManager", extensionManager);
            apiBuilder.setExtensionService((IExtensionService)extensionManager);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerMailService(HttpServletRequest request, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            IMailService mailSender = MailServiceFactory.createMailService(request);
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "mail", mailSender);
            apiBuilder.setMailService(mailSender);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerConfigurationStorage(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder, DataSource dataSource) {
        try {
            ConfigStorageUtils configStorageUtils = new ConfigStorageUtils(dataSource);
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "config", configStorageUtils);
            apiBuilder.setConfigurationStorage(configStorageUtils);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerFileStorage(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder, DataSource dataSource) {
        try {
            FileStorageUtils fileStorageUtils = new FileStorageUtils(dataSource);
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "fileStorage", fileStorageUtils);
            apiBuilder.setFileStorage(fileStorageUtils);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerBinaryStorage(Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder, DataSource dataSource) {
        try {
            StorageUtils storageUtils = new StorageUtils(dataSource);
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "storage", storageUtils);
            apiBuilder.setBinaryStorage(storageUtils);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerInitialContext(HttpServletRequest request, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        try {
            if (request != null) {
                InitialContext initialContext = (InitialContext)request.getSession().getAttribute("InitialContext");
                this.registerDefaultVariableInContextAndScope(executionContext, scope, "jndi", initialContext);
                apiBuilder.setInitialContext(initialContext);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    protected void registerRequestInput(Object input, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "input", input);
        apiBuilder.setRequestInput(input);
    }

    protected void registerUserName(HttpServletRequest request, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        String userName = RepositoryFacade.getUser(request);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "user", userName);
        apiBuilder.setUserName(userName);
    }

    protected void registerRepository(Map<Object, Object> executionContext, IRepository repository, Object scope, InjectedAPIBuilder apiBuilder) {
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "repository", repository);
        apiBuilder.setRepository(repository);
    }

    protected void registerResponse(HttpServletResponse response, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "response", response);
        apiBuilder.setResponse(response);
    }

    protected void registerRequest(HttpServletRequest request, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "request", request);
        apiBuilder.setRequest(request);
        if (request != null) {
            this.registerDefaultVariableInContextAndScope(executionContext, scope, "session", request.getSession());
            apiBuilder.setSession(request.getSession());
        }
    }

    protected DataSource registerDefaultDatasource(HttpServletRequest request, Map<Object, Object> executionContext, Object scope, InjectedAPIBuilder apiBuilder) {
        DataSource dataSource = DataSourceFacade.getInstance().getDataSource(request);
        this.registerDefaultVariableInContextAndScope(executionContext, scope, "datasource", dataSource);
        apiBuilder.setDatasource(dataSource);
        return dataSource;
    }

    @Override
    public byte[] readResourceData(IRepository repository, String repositoryPath) throws IOException {
        IResource resource = repository.getResource(repositoryPath);
        if (!resource.exists()) {
            String logMsg = String.format(THERE_IS_NO_RESOURCE_AT_THE_SPECIFIED_SERVICE_PATH, resource.getName(), repositoryPath);
            logger.error(logMsg);
            throw new IOException(logMsg);
        }
        return resource.getContent();
    }

    @Override
    public Module retrieveModule(IRepository repository, String module, String extension, String ... rootPaths) throws IOException {
        String[] stringArray = rootPaths;
        int n = rootPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String rootPath = stringArray[n2];
            String resourcePath = this.createResourcePath(rootPath, module, extension);
            IResource resource = repository.getResource(resourcePath);
            if (resource.exists()) {
                return new Module(this.getModuleName(resource.getPath()), resource.getPath(), this.readResourceData(repository, resourcePath));
            }
            ++n2;
        }
        String logMsg = String.format(THERE_IS_NO_RESOURCE_AT_THE_SPECIFIED_SERVICE_PATH, String.valueOf(module) + extension, Arrays.toString(rootPaths));
        logger.error(logMsg);
        throw new FileNotFoundException(logMsg);
    }

    @Override
    public List<Module> retrieveModulesByExtension(IRepository repository, String extension, String ... rootPaths) throws IOException {
        HashMap<String, Module> modules = new HashMap<String, Module>();
        int i = rootPaths.length - 1;
        while (i >= 0) {
            List entities = repository.searchName(rootPaths[i], "%" + extension, false);
            for (IEntity entity : entities) {
                if (!entity.exists()) continue;
                String path = entity.getPath();
                String moduleName = this.getModuleName(path);
                Module module = new Module(moduleName, path, this.readResourceData(repository, path), entity.getInformation());
                modules.put(moduleName, module);
            }
            --i;
        }
        return Arrays.asList(modules.values().toArray(new Module[0]));
    }

    private String getModuleName(String path) {
        path = FilenameUtils.separatorsToUnix((String)path);
        String workspace = "workspace/";
        String scriptingServices = String.valueOf(this.getModuleType(path)) + "/";
        int indexOfSandbox = path.indexOf("sandbox");
        int indexOfRegistry = path.indexOf("registry");
        String result = null;
        if (indexOfSandbox > 0 || indexOfRegistry > 0) {
            int indexOfScriptingServices = path.indexOf(scriptingServices);
            result = path.substring(indexOfScriptingServices + scriptingServices.length());
        } else {
            int indexOfWorkspace = path.indexOf(workspace);
            result = path.substring(indexOfWorkspace + workspace.length());
            result = result.replace(scriptingServices, "");
        }
        return result;
    }

    protected abstract String getModuleType(String var1);

    private String createResourcePath(String root, String module, String extension) {
        StringBuilder buff = new StringBuilder().append(root).append("/").append(module);
        if (extension != null) {
            buff.append(extension);
        }
        String resourcePath = buff.toString();
        return resourcePath;
    }

    @Override
    public ICollection getCollection(IRepository repository, String repositoryPath) throws IOException {
        ICollection collection = repository.getCollection(repositoryPath);
        if (!collection.exists()) {
            String logMsg = String.format(THERE_IS_NO_COLLECTION_AT_THE_SPECIFIED_SERVICE_PATH, collection.getName(), repositoryPath);
            logger.error(logMsg);
            throw new IOException(logMsg);
        }
        return collection;
    }

    @Override
    public IResource getResource(IRepository repository, String repositoryPath) throws IOException {
        IResource resource = repository.getResource(repositoryPath);
        if (!resource.exists()) {
            String logMsg = String.format(THERE_IS_NO_RESOURCE_AT_THE_SPECIFIED_SERVICE_PATH, resource.getName(), repositoryPath);
            logger.error(logMsg);
            throw new IOException(logMsg);
        }
        return resource;
    }
}

