/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.is.wizard;

import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.is.wizard.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;

public class IntegrationServiceTemplateTargetLocationPage
extends TemplateTargetLocationPage {
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateTargetLocationPage";
    private static final String SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME = Messages.IntegrationServiceTemplateTargetLocationPage_SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME;
    private static final String TARGET_LOCATION = Messages.IntegrationServiceTemplateTargetLocationPage_TARGET_LOCATION;
    private static final String FILE_JOB_NAME = "job_name.job";
    private static final String FILE_FLOW_NAME = "flow_name.flow";
    private static final String FILE_LISTENER_NAME = "listener_name.listener";
    private static final String EXT_JOB = ".job";
    private static final String EXT_FLOW = ".flow";
    private static final String EXT_LISTENER = ".listener";
    private IntegrationServiceTemplateModel model;

    protected IntegrationServiceTemplateTargetLocationPage(IntegrationServiceTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TARGET_LOCATION);
        this.setDescription(SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME);
    }

    protected void checkPageStatus() {
        if (this.getModel().getTargetLocation() == null || "".equals(this.getModel().getTargetLocation())) {
            this.setPageComplete(false);
            return;
        }
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.model.validateLocation();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getDefaultFileName(String preset) {
        String defaultName = FILE_FLOW_NAME;
        if (this.model.getTemplate().getLocation().endsWith(EXT_FLOW)) {
            defaultName = preset == null ? FILE_FLOW_NAME : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + EXT_FLOW;
        } else if (this.model.getTemplate().getLocation().endsWith(EXT_JOB)) {
            defaultName = preset == null ? FILE_JOB_NAME : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + EXT_JOB;
        } else if (this.model.getTemplate().getLocation().endsWith(EXT_LISTENER)) {
            defaultName = preset == null ? FILE_LISTENER_NAME : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + EXT_LISTENER;
        }
        return defaultName;
    }

    protected boolean isForcedFileName() {
        return true;
    }

    protected String getArtifactContainerName() {
        return "IntegrationServices";
    }
}

