/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.status.LogProgressMonitor;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.ui.common.TemplateSourceMetadata;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewerUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.velocity.VelocityGenerator;

public abstract class TemplateGenerator {
    private static final String THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF = Messages.TemplateGenerator_THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF;
    private static final Logger logger = Logger.getLogger(TemplateGenerator.class);
    private VelocityGenerator velocityGenerator = new VelocityGenerator();
    private List<IFile> createdFiles = new ArrayList<IFile>();

    protected abstract GenerationModel getModel();

    protected abstract Map<String, Object> prepareParameters();

    protected abstract String getLogTag();

    public void generate() throws Exception {
        this.generate(null);
    }

    public void generate(HttpServletRequest request) throws Exception {
        TemplateSourceMetadata[] sources = this.getModel().getTemplate().getTemplateMetadata().getSources();
        int i = 0;
        while (i < sources.length) {
            String renaming;
            String targetLocation = this.getModel().getTargetLocation();
            String name = sources[i].getName();
            targetLocation = this.calcTargetLocation(targetLocation, name);
            if (name != null && name.indexOf("/") > 1) {
                name = name.substring(name.indexOf("/"));
            }
            if ((renaming = sources[i].getRename()) != null && !"".equals(renaming)) {
                String baseFilename = FilenameUtils.getBaseName((String)this.getModel().getFileName());
                String originalExtension = FilenameUtils.getExtension((String)name);
                name = String.valueOf(String.format(renaming, baseFilename)) + '.' + originalExtension;
            }
            if (sources[i].isGenerate()) {
                if (i == 0) {
                    this.generateFile(sources[i].getLocation(), targetLocation, this.getModel().getFileName(), request);
                } else {
                    this.generateFile(sources[i].getLocation(), targetLocation, name, request);
                }
            } else {
                this.copyFile(name, targetLocation, sources[i].getLocation(), request);
            }
            ++i;
        }
    }

    private String calcTargetLocation(String targetLocation, String name) {
        if (name != null && name.indexOf("/") > 1) {
            String alternativeTarget = null;
            if (name.startsWith("DataStructures")) {
                alternativeTarget = "DataStructures";
            } else if (name.startsWith("ExtensionDefinitions")) {
                alternativeTarget = "ExtensionDefinitions";
            } else if (name.startsWith("IntegrationServices")) {
                alternativeTarget = "IntegrationServices";
            } else if (name.startsWith("ScriptingServices")) {
                alternativeTarget = "ScriptingServices";
            } else if (name.startsWith("SecurityConstraints")) {
                alternativeTarget = "SecurityConstraints";
            } else if (name.startsWith("TestCases")) {
                alternativeTarget = "TestCases";
            } else if (name.startsWith("WebContent")) {
                alternativeTarget = "WebContent";
            } else if (name.startsWith("WikiContent")) {
                alternativeTarget = "WikiContent";
            } else if (name.startsWith("MobileApplications")) {
                alternativeTarget = "MobileApplications";
            }
            if (alternativeTarget != null) {
                Path location = new Path(targetLocation);
                Path target = new Path("/");
                String[] segments = location.segments();
                int i = 1;
                String[] stringArray = segments;
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    target = i != 2 ? target.append(segment) : target.append(alternativeTarget);
                    ++i;
                    ++n2;
                }
                return target.toString();
            }
        }
        return targetLocation;
    }

    public void generateFile(String templateLocation, String targetLocation, String fileName) throws Exception {
        this.generateFile(templateLocation, targetLocation, fileName, null);
    }

    public void generateFile(String templateLocation, String targetLocation, String fileName, HttpServletRequest request) throws Exception {
        Map<String, Object> parameters = this.prepareParameters();
        InputStream in = GenerationModel.getInputStreamByTemplateLocation(templateLocation, request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.velocityGenerator.generate(in, (OutputStream)out, parameters, this.getLogTag());
        byte[] bytes = out.toByteArray();
        bytes = this.afterGeneration(bytes);
        IPath location = new Path(targetLocation).append(fileName);
        this.createFile(location, bytes, request);
    }

    protected byte[] afterGeneration(byte[] bytes) {
        return bytes;
    }

    protected void createFile(IPath location, byte[] bytes, HttpServletRequest request) throws Exception {
        IWorkspace workspace = WorkspaceLocator.getWorkspace((HttpServletRequest)request);
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile(location);
        if (file.exists()) {
            logger.warn(String.format(THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF, location));
        } else {
            LogProgressMonitor monitor = null;
            if (request != null) {
                monitor = new LogProgressMonitor();
            }
            this.createMissingParents(file, (IProgressMonitor)monitor);
            file.create((InputStream)new ByteArrayInputStream(bytes), false, (IProgressMonitor)monitor);
            this.createdFiles.add(file);
        }
        if (request == null) {
            IContainer parent = file.getParent();
            if (parent != null) {
                WorkspaceViewerUtils.expandElement((Object)parent);
            }
            WorkspaceViewerUtils.selectElement((Object)file);
        }
    }

    private void createMissingParents(IFile file, IProgressMonitor monitor) throws CoreException {
        Stack<IContainer> missingParents = new Stack<IContainer>();
        IContainer parent = file.getParent();
        while (!parent.exists()) {
            missingParents.push(parent);
            parent = parent.getParent();
        }
        while (!missingParents.isEmpty()) {
            IContainer next = (IContainer)missingParents.pop();
            if (!(next instanceof IFolder)) continue;
            ((IFolder)next).create(false, true, monitor);
        }
    }

    protected void copyFile(String targetFileName, String targetLocation, String templateLocation, HttpServletRequest request) throws IOException, Exception {
        IPath location = new Path(targetLocation).append(targetFileName);
        InputStream in = GenerationModel.getInputStreamByTemplateLocation(templateLocation, request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        this.createFile(location, out.toByteArray(), request);
    }

    public List<IFile> getGeneratedFiles() {
        return this.createdFiles;
    }

    public VelocityGenerator getVelocityGenerator() {
        return this.velocityGenerator;
    }
}

