/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository;

import java.util.HashMap;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.api.RepositoryFactory;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;

public class RepositoryFacade {
    private static final String REPOSITORY = "repository-instance";
    private static RepositoryFacade instance;

    public static RepositoryFacade getInstance() {
        if (instance == null) {
            instance = new RepositoryFacade();
        }
        return instance;
    }

    public IRepository getRepository() throws RepositoryException {
        HttpServletRequest request = CommonIDEParameters.getRequest();
        return this.getRepository(request);
    }

    public IRepository getRepository(HttpServletRequest request) throws RepositoryException {
        IRepository repository;
        if (request == null) {
            request = CommonIDEParameters.getRequest();
        }
        if ((repository = this.getRepositoryInstance(request)) != null) {
            return repository;
        }
        try {
            DataSource dataSource = this.lookupDataSource(request);
            String user = this.getUser(request);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("datasource", dataSource);
            parameters.put("user", user);
            parameters.put("recreate", Boolean.FALSE);
            repository = RepositoryFactory.createRepository(parameters);
            this.saveRepositoryInstance(request, repository);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        return repository;
    }

    public DataSource lookupDataSource(HttpServletRequest request) throws NamingException {
        return DataSourceFacade.getInstance().getDataSource(request);
    }

    public String getUser(HttpServletRequest request) {
        String user = CommonIDEParameters.getUserName((HttpServletRequest)request);
        try {
            if (request != null) {
                user = RequestUtils.getUser((HttpServletRequest)request);
            }
        }
        catch (Exception exception) {}
        return user;
    }

    private IRepository getRepositoryInstance(HttpServletRequest request) {
        return (IRepository)CommonIDEParameters.getObject((String)REPOSITORY, (HttpServletRequest)request);
    }

    public void saveRepositoryInstance(HttpServletRequest request, IRepository repository) {
        if (request == null) {
            return;
        }
        CommonIDEParameters.setObject((String)REPOSITORY, (Object)repository);
    }
}

