/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.is.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.is.wizard.IntegrationServiceTemplateModel;

public class IntegrationServiceTemplateGenerator
extends TemplateGenerator {
    private static final String LOG_TAG = "INTEGRATION_SERVICE_GENERATOR";
    private IntegrationServiceTemplateModel model;

    public IntegrationServiceTemplateGenerator(IntegrationServiceTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", this.model.getId());
        parameters.put("endpointAddress", this.model.getEndpointAddress());
        parameters.put("projectName", this.model.getProjectName());
        String fileNameNoExtension = this.model.getFileNameNoExtension();
        parameters.put("fileNameNoExtension", fileNameNoExtension);
        String fileNameNoExtensionTitle = fileNameNoExtension;
        if (fileNameNoExtension != null && fileNameNoExtension.length() > 1) {
            char[] chars = fileNameNoExtension.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            fileNameNoExtensionTitle = new String(chars);
        }
        parameters.put("fileNameNoExtensionTitle", fileNameNoExtensionTitle);
        return parameters;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        byte[] result = this.model.normalizeEscapes(bytes);
        return result;
    }
}

