/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.publish.ui.command;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.publish.ui.command.Messages;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.view.WebViewerView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AutoActivator
implements IResourceChangeListener {
    private static final String FAILED_TO_ACTIVATE_PROJECT = Messages.AutoActivateAction_FAILED_TO_ACTIVATE_PROJECT;
    private static final String FAILED_TO_ACTIVATE_FILE = Messages.AutoActivateAction_FAILED_TO_ACTIVATE_FILE;
    private static final String FAILED_TO_PUBLISH_PROJECT = Messages.AutoActivateAction_FAILED_TO_PUBLISH_PROJECT;
    private static final String AUTO_ACTIVATION_FAILED = Messages.AutoActivateAction_AUTO_ACTIVATION_FAILED;
    private static final String AUTO_PUBLISH_FAILED = Messages.AutoActivateAction_AUTO_PUBLISH_FAILED;

    public void registerListener() {
        WorkspaceLocator.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void unregisterListener() {
        WorkspaceLocator.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.autoActivate(event);
        this.autoPublish(event);
    }

    private void autoPublish(IResourceChangeEvent event) {
        if (!CommonIDEParameters.isAutoPublishEnabled()) {
            return;
        }
        IResource delta = event.getResource();
        IProject project = delta.getProject();
        try {
            PublishManager.publishProject((IProject)project);
        }
        catch (PublishException publishException) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AUTO_PUBLISH_FAILED, (String)(String.valueOf(FAILED_TO_PUBLISH_PROJECT) + project.getName()));
        }
    }

    private void autoActivate(IResourceChangeEvent event) {
        if (!CommonIDEParameters.isAutoActivateEnabled()) {
            return;
        }
        IResource delta = event.getResource();
        if (delta == null && event.getDelta() != null) {
            delta = this.locateResource(event);
        }
        if (delta != null) {
            if (delta instanceof IFile) {
                this.activateFile((IFile)delta);
            } else if (delta.getProject() != null) {
                this.activate(delta.getProject());
            }
        }
    }

    private IResource locateResource(IResourceChangeEvent event) {
        IResource resource = null;
        if (event.getDelta().getAffectedChildren().length > 0) {
            resource = this.locateResourceFromChild(event.getDelta().getAffectedChildren()[0]);
        }
        return resource;
    }

    private IResource locateResourceFromChild(IResourceDelta resourceDelta) {
        IResource resource = null;
        resource = resourceDelta.getAffectedChildren().length > 0 ? this.locateResourceFromChild(resourceDelta.getAffectedChildren()[0]) : resourceDelta.getResource();
        return resource;
    }

    private void activate(IProject project) {
        try {
            PublishManager.activateProject((IProject)project);
        }
        catch (PublishException publishException) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AUTO_ACTIVATION_FAILED, (String)(String.valueOf(FAILED_TO_ACTIVATE_PROJECT) + project.getName()));
        }
        WebViewerView.refreshWebViewerViewIfVisible();
    }

    private void activateFile(IFile file) {
        try {
            List publishers = PublishManager.getPublishers();
            for (IPublisher iPublisher : publishers) {
                IPublisher publisher = iPublisher;
                if (!publisher.isAutoActivationAllowed()) continue;
                publisher.activateFile(file);
            }
        }
        catch (PublishException publishException) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AUTO_ACTIVATION_FAILED, (String)(String.valueOf(FAILED_TO_ACTIVATE_FILE) + file.getName()));
        }
        WebViewerView.refreshWebViewerViewIfVisible();
    }
}

