/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.common.dual;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.ext.utils.EnvUtils;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ClientService;

public class DualParameters {
    private static final Logger logger = Logger.getLogger(DualParameters.class);
    public static final String SET_AUTO_ACTIVATE = "autoActivateEnabled";
    public static final String SET_AUTO_PUBLISH = "autoPublishEnabled";
    public static final String SANDBOX_ENABLED = "enableSandbox";
    public static final String RUNTIME_URL_DEFAULT = "";
    public static final String SERVICES_URL_DEFAULT = "";
    public static final String HC_LOCAL_HTTP_PORT = "HC_LOCAL_HTTP_PORT";
    public static final String HC_APPLICATION_URL = "HC_APPLICATION_URL";
    public static final String HC_APPLICATION = "HC_APPLICATION";
    public static final String HC_ACCOUNT = "HC_ACCOUNT";
    public static final String HC_REGION = "HC_REGION";
    public static final String HC_HOST = "HC_HOST";
    public static final String GUEST_USER = "guest";
    private static final boolean SET_SANDBOX_ENABLED_DEFAULT = false;
    private static final boolean SET_AUTO_ACTIVATE_DEFAULT = true;
    private static final boolean SET_AUTO_PUBLIUSH_DEFAULT = true;

    public static void initSystemParameters() {
        HttpServletRequest req = RWT.getRequest();
        String parameterHC_HOST = System.getProperty(HC_HOST);
        req.getSession().setAttribute(HC_HOST, (Object)parameterHC_HOST);
        String parameterHC_REGION = System.getProperty(HC_REGION);
        req.getSession().setAttribute(HC_REGION, (Object)parameterHC_REGION);
        String parameterHC_ACCOUNT = System.getProperty(HC_ACCOUNT);
        req.getSession().setAttribute(HC_ACCOUNT, (Object)parameterHC_ACCOUNT);
        String parameterHC_APPLICATION = System.getProperty(HC_APPLICATION);
        req.getSession().setAttribute(HC_APPLICATION, (Object)parameterHC_APPLICATION);
        String parameterHC_APPLICATION_URL = System.getProperty(HC_APPLICATION_URL);
        req.getSession().setAttribute(HC_APPLICATION_URL, (Object)parameterHC_APPLICATION_URL);
        String parameterHC_LOCAL_HTTP_PORT = System.getProperty(HC_LOCAL_HTTP_PORT);
        req.getSession().setAttribute(HC_LOCAL_HTTP_PORT, (Object)parameterHC_LOCAL_HTTP_PORT);
    }

    public static String get(String name) {
        try {
            String parameter = (String)RWT.getRequest().getSession().getAttribute(name);
            return parameter;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Object getObject(String name) {
        return DualParameters.getObject(name, null);
    }

    public static Object getObject(String name, HttpServletRequest request) {
        try {
            if (request == null) {
                request = RWT.getRequest();
            }
            Object parameter = request.getSession().getAttribute(name);
            return parameter;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void set(String name, String value) {
        try {
            RWT.getRequest().getSession().setAttribute(name, (Object)value);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void set(String name, Object value) {
        try {
            RWT.getRequest().getSession().setAttribute(name, value);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void setObject(String name, Object value) {
        try {
            RWT.getRequest().getSession().setAttribute(name, value);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static String getRuntimeUrl() {
        String runtimeUrl = EnvUtils.getEnv((String)"runtimeUrl");
        if (runtimeUrl == null) {
            runtimeUrl = "";
        }
        return runtimeUrl;
    }

    public static boolean isAutoPublishEnabled() {
        String autoPublishEnabled = EnvUtils.getEnv((String)SET_AUTO_PUBLISH);
        boolean result = true;
        if (autoPublishEnabled != null) {
            result = Boolean.parseBoolean(autoPublishEnabled);
        }
        return result;
    }

    public static boolean isAutoActivateEnabled() {
        String autoPublishEnabled = EnvUtils.getEnv((String)SET_AUTO_ACTIVATE);
        boolean result = true;
        if (autoPublishEnabled != null) {
            result = Boolean.parseBoolean(autoPublishEnabled);
        }
        return result;
    }

    public static boolean isSandboxEnabled() {
        String sandboxEnabledStr = EnvUtils.getEnv((String)SANDBOX_ENABLED);
        boolean result = false;
        if (sandboxEnabledStr != null) {
            result = Boolean.parseBoolean(sandboxEnabledStr);
        }
        return result;
    }

    public static String getServicesUrl() {
        String servicesUrl;
        String runtimeUrl = EnvUtils.getEnv((String)"runtimeUrl");
        if (runtimeUrl == null || "".equals(runtimeUrl)) {
            runtimeUrl = RWT.getRequest().getContextPath();
        }
        if ((servicesUrl = EnvUtils.getEnv((String)"servicesUrl")) == null) {
            servicesUrl = "";
        }
        return String.valueOf(runtimeUrl) + servicesUrl;
    }

    public static <T extends ClientService> T getService(Class<T> clazz) {
        return (T)RWT.getClient().getService(clazz);
    }

    public static String getContextPath() {
        return RWT.getRequest().getContextPath();
    }

    public static HttpServletRequest getRequest() {
        return RWT.getRequest();
    }

    public static String getUserName(HttpServletRequest request) {
        String user = GUEST_USER;
        try {
            if (request == null) {
                request = RWT.getRequest();
            }
            user = request.getRemoteUser();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        if (user == null && !DualParameters.isRolesEnabled().booleanValue()) {
            user = RequestUtils.getCookieValue((HttpServletRequest)request, (String)"dirigible_anonymous_user");
        }
        if (user == null) {
            user = GUEST_USER;
        }
        return user;
    }

    public static Boolean isRolesEnabled() {
        Boolean rolesEnabled = Boolean.parseBoolean(EnvUtils.getEnv((String)"enableRoles"));
        return rolesEnabled;
    }

    public static boolean isUserInRole(String role) {
        if (DualParameters.isRolesEnabled().booleanValue()) {
            return RWT.getRequest().isUserInRole(role);
        }
        return true;
    }

    public static String getSessionId() {
        String sessionId = RWT.getRequest().getSession(true).getId();
        return sessionId;
    }

    public static final boolean isRAP() {
        return true;
    }

    public static final boolean isRCP() {
        return false;
    }
}

