/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.dnd.dragsourcekit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.dnd.DNDUtil;
import org.eclipse.swt.internal.dnd.dragsourcekit.DragSourceOperationHandler;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Widget;

public final class DragSourceLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.DragSource";
    private static final String PROP_TRANSFER = "transfer";
    private static final String PROP_DRAG_START_LISTENER = "DragStart";
    private static final String PROP_DRAG_END_LISTENER = "DragEnd";
    private static final Transfer[] DEFAULT_TRANSFER = new Transfer[0];

    @Override
    public void preserveValues(Widget widget) {
        DragSource dragSource = (DragSource)widget;
        WidgetLCAUtil.preserveProperty((Widget)dragSource, PROP_TRANSFER, dragSource.getTransfer());
        WidgetLCAUtil.preserveListener((Widget)dragSource, PROP_DRAG_START_LISTENER, EventLCAUtil.isListening(dragSource, 2008));
        WidgetLCAUtil.preserveListener((Widget)dragSource, PROP_DRAG_END_LISTENER, EventLCAUtil.isListening(dragSource, 2000));
    }

    @Override
    public void readData(Widget widget) {
    }

    @Override
    public void renderInitialization(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(dragSource, TYPE);
        remoteObject.setHandler(new DragSourceOperationHandler(dragSource));
        remoteObject.set("control", WidgetUtil.getId(dragSource.getControl()));
        remoteObject.set("style", DNDUtil.convertOperations(dragSource.getStyle()));
    }

    @Override
    public void renderChanges(Widget widget) throws IOException {
        DragSource dragSource = (DragSource)widget;
        DragSourceLCA.renderTransfer(dragSource);
        DragSourceLCA.renderCancel(dragSource);
        WidgetLCAUtil.renderListener((Widget)dragSource, PROP_DRAG_START_LISTENER, EventLCAUtil.isListening(dragSource, 2008), false);
        WidgetLCAUtil.renderListener((Widget)dragSource, PROP_DRAG_END_LISTENER, EventLCAUtil.isListening(dragSource, 2000), false);
    }

    private static void renderTransfer(DragSource dragSource) {
        Transfer[] newValue = dragSource.getTransfer();
        if (WidgetLCAUtil.hasChanged(dragSource, PROP_TRANSFER, newValue, DEFAULT_TRANSFER)) {
            JsonArray renderValue = DNDUtil.convertTransferTypes(newValue);
            RemoteObjectFactory.getRemoteObject(dragSource).set(PROP_TRANSFER, renderValue);
        }
    }

    private static void renderCancel(DragSource dragSource) {
        if (DNDUtil.isCanceled()) {
            RemoteObjectFactory.getRemoteObject(dragSource).call("cancel", null);
        }
    }
}

