/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.websocket.Session;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.ResultResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.URIUtils;

public class GetResourceContentHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();
    private static final String IMAGE_EXTS = "png|svg|jpg|jpeg";

    @Override
    public void handle(String message, Session session) throws IOException {
        String pageContent;
        MessageRequest request = (MessageRequest)GSON.fromJson(message, MessageRequest.class);
        Integer id = request.getId();
        String url = (String)request.getParams().get("url");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isImage(url)) {
            URLConnection connection = new URL(url).openConnection();
            InputStream inputStream = connection.getInputStream();
            result.put("base64Encoded", true);
            pageContent = this.getEncodedImage(inputStream);
        } else {
            result.put("base64Encoded", false);
            ScriptRepository repository = ScriptRepository.getInstance();
            pageContent = repository.getSourceFor(repository.getScriptIdByURL(url));
        }
        result.put("content", pageContent);
        ResultResponse content = new ResultResponse(id, result);
        MessageDispatcher.sendMessage(GSON.toJson((Object)content), session);
    }

    private boolean isImage(String url) {
        String extension = URIUtils.getURIextension(url);
        return Pattern.compile(IMAGE_EXTS).matcher(extension).find();
    }

    private String getEncodedImage(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = stream.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        byte[] fileContent = baos.toByteArray();
        byte[] encoded = Base64.encodeBase64((byte[])fileContent);
        return new String(encoded);
    }
}

