/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.shared;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.dirigible.ide.workspace.ui.shared.IContentProvider;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.shared.Messages;
import org.eclipse.dirigible.ide.workspace.ui.shared.ValidationStatus;

public class URLContentProvider
implements IContentProvider {
    private static final String INVALID_URL_ADDRESS = Messages.URLContentProvider_INVALID_URL_ADDRESS;
    private String url;

    public URLContentProvider() {
        this("");
    }

    public URLContentProvider(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public IValidationStatus validate() {
        try {
            new URL(this.url);
            return ValidationStatus.createOk();
        }
        catch (MalformedURLException malformedURLException) {
            return ValidationStatus.createError(INVALID_URL_ADDRESS);
        }
    }

    @Override
    public InputStream getContent() throws IOException {
        return new URL(this.url).openStream();
    }
}

