/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import javax.servlet.http.Cookie;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.SettingStoreFactory;
import org.eclipse.rap.rwt.service.UISession;

public class SettingStoreManager {
    private static final String COOKIE_NAME = "settingStore";
    private static final int COOKIE_MAX_AGE_SEC = 7776000;
    private static long last = System.currentTimeMillis();
    private static int instanceCount;
    private SettingStoreFactory factory;

    public synchronized SettingStore getStore() {
        String storeId;
        UISession uiSession = ContextProvider.getUISession();
        SettingStore result = (SettingStore)uiSession.getAttribute(storeId = this.getStoreId());
        if (result == null) {
            result = this.factory.createSettingStore(storeId);
            uiSession.setAttribute(storeId, result);
        }
        return result;
    }

    public synchronized void register(SettingStoreFactory factory) {
        ParamCheck.notNull(factory, "factory");
        if (this.hasFactory()) {
            throw new IllegalStateException("There is already a SettingStoreFactory registered.");
        }
        this.factory = factory;
    }

    public void deregisterFactory() {
        if (!this.hasFactory()) {
            throw new IllegalStateException("There is no SettingStoreFactory for deregistration.");
        }
        this.factory = null;
    }

    public synchronized boolean hasFactory() {
        return this.factory != null;
    }

    private String getStoreId() {
        UISession uiSession = ContextProvider.getUISession();
        String result = (String)uiSession.getAttribute(COOKIE_NAME);
        if (result == null) {
            result = this.getStoreIdFromCookie();
            if (result == null) {
                result = this.createUniqueStoreId();
            }
            Cookie cookie = new Cookie(COOKIE_NAME, result);
            cookie.setSecure(ContextProvider.getRequest().isSecure());
            cookie.setMaxAge(7776000);
            ContextProvider.getResponse().addCookie(cookie);
            uiSession.setAttribute(COOKIE_NAME, result);
        }
        return result;
    }

    private String getStoreIdFromCookie() {
        String result = null;
        Cookie[] cookies = ContextProvider.getRequest().getCookies();
        if (cookies != null) {
            int i = 0;
            while (result == null && i < cookies.length) {
                String value;
                Cookie cookie = cookies[i];
                if (COOKIE_NAME.equals(cookie.getName()) && SettingStoreManager.isValidCookieValue(value = cookie.getValue())) {
                    result = value;
                }
                ++i;
            }
        }
        return result;
    }

    private synchronized String createUniqueStoreId() {
        long now = System.currentTimeMillis();
        if (last == now) {
            ++instanceCount;
        } else {
            last = now;
            instanceCount = 0;
        }
        return String.valueOf(String.valueOf(now)) + "_" + String.valueOf(instanceCount);
    }

    static boolean isValidCookieValue(String value) {
        boolean result = false;
        int index = value.indexOf(95);
        if (index != -1) {
            try {
                Long.parseLong(value.substring(0, index));
                Integer.parseInt(value.substring(index + 1));
                result = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

