/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import org.eclipse.dirigible.ide.common.CommonUtils;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.Messages;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;

public class JavascriptServiceTemplateTargetLocationPage
extends TemplateTargetLocationPage {
    private static final long serialVersionUID = 1L;
    private static final String SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME = Messages.JavascriptServiceTemplateTargetLocationPage_SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME;
    private static final String TARGET_LOCATION = Messages.JavascriptServiceTemplateTargetLocationPage_TARGET_LOCATION;
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateTargetLocationPage";
    private JavascriptServiceTemplateModel model;

    protected JavascriptServiceTemplateTargetLocationPage(JavascriptServiceTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(TARGET_LOCATION);
        this.setDescription(SELECT_THE_TARGET_LOCATION_AND_THE_TARGET_FILE_NAME);
    }

    protected void checkPageStatus() {
        if (this.getModel().getTargetLocation() == null || "".equals(this.getModel().getTargetLocation())) {
            this.setPageComplete(false);
            return;
        }
        if (this.getModel().getFileName() == null || "".equals(this.getModel().getFileName())) {
            this.setPageComplete(false);
            return;
        }
        IValidationStatus status = this.model.validateLocation();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getDefaultFileName(String preset) {
        String jsOrLibName = "/org/eclipse/dirigible/ide/template/ui/js/templates/guid-generator.js".equals(this.model.getTemplate().getLocation()) ? "library" : "service";
        String jsOrLibExt = "js";
        if ("/org/eclipse/dirigible/ide/template/ui/js/templates/ruby-service.rb".equals(this.model.getTemplate().getLocation())) {
            jsOrLibExt = "rb";
        } else if ("/org/eclipse/dirigible/ide/template/ui/js/templates/groovy-service.groovy".equals(this.model.getTemplate().getLocation())) {
            jsOrLibExt = "groovy";
        } else if ("/org/eclipse/dirigible/ide/template/ui/js/templates/terminal-command.command".equals(this.model.getTemplate().getLocation())) {
            jsOrLibExt = "command";
        } else if ("/org/eclipse/dirigible/ide/template/ui/js/templates/java-service.java_".equals(this.model.getTemplate().getLocation())) {
            jsOrLibExt = "java";
        }
        return preset == null ? String.valueOf(jsOrLibName) + "_name." + jsOrLibExt : String.valueOf(CommonUtils.getFileNameNoExtension((String)preset)) + "." + jsOrLibExt;
    }

    protected boolean isForcedFileName() {
        return true;
    }

    protected String getArtifactContainerName() {
        return "ScriptingServices";
    }
}

