/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2.participant;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;
import org.eclipse.xtext.ide.refactoring.IResourceRelocationStrategy;
import org.eclipse.xtext.ide.refactoring.RefactoringIssueAcceptor;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationChange;
import org.eclipse.xtext.ide.refactoring.ResourceRelocationContext;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ui.refactoring2.ChangeConverter;
import org.eclipse.xtext.ui.refactoring2.LtkIssueAcceptor;
import org.eclipse.xtext.ui.refactoring2.ResourceURIConverter;
import org.eclipse.xtext.ui.refactoring2.participant.ResourceRelocationStrategyRegistry;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.resource.LiveScopeResourceSetInitializer;
import org.eclipse.xtext.util.IAcceptor;

public class ResourceRelocationProcessor {
    private static final Logger LOG = Logger.getLogger(ResourceRelocationProcessor.class);
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private LiveScopeResourceSetInitializer liveScopeResourceSetInitializer;
    @Inject
    private LtkIssueAcceptor issues;
    @Inject
    private ResourceURIConverter resourceURIConverter;
    @Inject
    private Provider<IChangeSerializer> changeSerializerProvider;
    @Inject
    private ResourceRelocationStrategyRegistry strategyRegistry;
    @Inject
    private ChangeConverter.Factory changeConverterFactory;
    private final List<ResourceRelocationChange> uriChanges = new ArrayList<ResourceRelocationChange>();
    private final Set<IResource> excludedResources = new HashSet<IResource>();
    private IProject project;

    public Change createChange(String name, ResourceRelocationContext.ChangeType type, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.uriChanges.isEmpty()) {
            return null;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm);
        subMonitor.beginTask("Preparing the refactoring...", 5);
        IChangeSerializer changeSerializer = (IChangeSerializer)this.changeSerializerProvider.get();
        ResourceSet resourceSet = this.resourceSetProvider.get(this.project);
        ResourceRelocationContext context = new ResourceRelocationContext(type, this.uriChanges, (RefactoringIssueAcceptor)this.issues, changeSerializer, resourceSet);
        boolean persistedIndexUsageRequested = this.isPersistedIndexUsageRequested(context);
        this.initializeResourceSet(persistedIndexUsageRequested, context);
        this.executeParticipants(context, subMonitor.split(1));
        ChangeConverter changeConverter = this.changeConverterFactory.create(name, (Predicate<Change>)((Predicate)it -> !(it instanceof MoveResourceChange) && !(it instanceof RenameResourceChange) || !this.excludedResources.contains(it.getModifiedElement())), this.issues);
        SubMonitor modificationApplicationMonitor = subMonitor.split(4);
        changeSerializer.setProgressMonitor((IProgressMonitor)modificationApplicationMonitor);
        changeSerializer.applyModifications((IAcceptor)changeConverter);
        modificationApplicationMonitor.done();
        return changeConverter.getChange();
    }

    protected boolean isPersistedIndexUsageRequested(ResourceRelocationContext context) {
        List<? extends IResourceRelocationStrategy> strategies = this.strategyRegistry.getStrategies();
        return strategies.stream().anyMatch(strategy -> strategy.requiresUsageOfPersistedIndex(context));
    }

    protected void initializeResourceSet(boolean persistedIndexUsageRequested, ResourceRelocationContext context) {
        if (persistedIndexUsageRequested) {
            context.getResourceSet().getLoadOptions().put("org.eclipse.xtext.builder.impl.PersistentDataAwareDirtyResource.PERSISTED_DESCRIPTIONS", Boolean.TRUE);
        } else {
            this.liveScopeResourceSetInitializer.initialize(context.getResourceSet());
        }
    }

    protected void executeParticipants(ResourceRelocationContext context, SubMonitor monitor) {
        List<? extends IResourceRelocationStrategy> strategies = this.strategyRegistry.getStrategies();
        if (context.getChangeType() == ResourceRelocationContext.ChangeType.COPY) {
            context.getChangeSerializer().setUpdateRelatedFiles(false);
        }
        monitor.setWorkRemaining(strategies.size());
        for (IResourceRelocationStrategy iResourceRelocationStrategy : strategies) {
            try {
                monitor.split(1);
                iResourceRelocationStrategy.applyChange(context);
            }
            catch (OperationCanceledException t) {
                this.issues.add(RefactoringIssueAcceptor.Severity.ERROR, "Operation was cancelled while applying resource changes", new Object[]{t});
                LOG.error((Object)t.getMessage(), (Throwable)t);
                break;
            }
        }
    }

    public void addChangedResource(IResource resource, IPath fromPath, IPath toPath) {
        if (this.project == null) {
            this.project = resource.getProject();
        }
        if (fromPath.isPrefixOf(resource.getFullPath())) {
            URI oldURI = this.resourceURIConverter.toURI(resource);
            URI newURI = this.resourceURIConverter.toURI(toPath.append(resource.getFullPath().removeFirstSegments(fromPath.segmentCount())));
            this.excludedResources.add(resource);
            if (resource instanceof IFile) {
                ResourceRelocationChange uriChange = new ResourceRelocationChange(oldURI, newURI, true);
                this.uriChanges.add(uriChange);
            } else if (resource instanceof IContainer) {
                ResourceRelocationChange uriChange = new ResourceRelocationChange(oldURI, newURI, false);
                this.uriChanges.add(uriChange);
                try {
                    IResource[] iResourceArray = ((IContainer)resource).members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        this.addChangedResource(member, fromPath, toPath);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    LtkIssueAcceptor getIssues() {
        return this.issues;
    }
}

