/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Comparator;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.ArrayUtil;

final class ComponentTree
implements Component2D {
    private double minY;
    private double maxY;
    private double minX;
    private double maxX;
    private Component2D left;
    private Component2D right;
    private final boolean splitX;
    private final Component2D component;

    protected ComponentTree(Component2D component, boolean splitX) {
        this.minY = component.getMinY();
        this.maxY = component.getMaxY();
        this.minX = component.getMinX();
        this.maxX = component.getMaxX();
        this.component = component;
        this.splitX = splitX;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        if (y <= this.maxY && x <= this.maxX) {
            if (this.component.contains(x, y)) {
                return true;
            }
            if (this.left != null && this.left.contains(x, y)) {
                return true;
            }
            if (this.right != null && (!this.splitX && y >= this.component.getMinY() || this.splitX && x >= this.component.getMinX()) && this.right.contains(x, y)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (minY <= this.maxY && minX <= this.maxX) {
            PointValues.Relation relation = this.component.relateTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relateTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX()) && (relation = this.right.relateTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (this.left != null || this.right != null) {
            throw new IllegalArgumentException("withinTriangle is not supported for shapes with more than one component");
        }
        return this.component.withinTriangle(minX, maxX, minY, maxY, aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (minY <= this.maxY && minX <= this.maxX) {
            PointValues.Relation relation = this.component.relate(minX, maxX, minY, maxY);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relate(minX, maxX, minY, maxY)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!this.splitX && maxY >= this.component.getMinY() || this.splitX && maxX >= this.component.getMinX()) && (relation = this.right.relate(minX, maxX, minY, maxY)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public static Component2D create(Component2D[] components) {
        if (components.length == 1) {
            return components[0];
        }
        ComponentTree root = ComponentTree.createTree(components, 0, components.length - 1, false);
        for (Component2D component : components) {
            root.minY = Math.min(root.minY, component.getMinY());
            root.minX = Math.min(root.minX, component.getMinX());
        }
        return root;
    }

    private static ComponentTree createTree(Component2D[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            Comparator comparator = splitX ? (left, right) -> {
                int ret = Double.compare(left.getMinX(), right.getMinX());
                if (ret == 0) {
                    ret = Double.compare(left.getMaxX(), right.getMaxX());
                }
                return ret;
            } : (left, right) -> {
                int ret = Double.compare(left.getMinY(), right.getMinY());
                if (ret == 0) {
                    ret = Double.compare(left.getMaxY(), right.getMaxY());
                }
                return ret;
            };
            ArrayUtil.select(components, low, high + 1, mid, comparator);
        }
        ComponentTree newNode = new ComponentTree(components[mid], splitX);
        newNode.left = ComponentTree.createTree(components, low, mid - 1, !splitX);
        newNode.right = ComponentTree.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.getMaxX());
            newNode.maxY = Math.max(newNode.maxY, newNode.left.getMaxY());
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.getMaxX());
            newNode.maxY = Math.max(newNode.maxY, newNode.right.getMaxY());
        }
        return newNode;
    }
}

