/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.DirtyStateEditorSupport;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.reconciler.IReconcileStrategyFactory;
import org.eclipse.xtext.ui.editor.reconciler.ReconcilerReplaceRegion;
import org.eclipse.xtext.util.CancelIndicator;

public class XtextDocumentReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ISourceViewerAware {
    private static final Logger log = Logger.getLogger(XtextDocumentReconcileStrategy.class);
    private List<IReconcileStrategyFactory> strategyFactories = new ArrayList<IReconcileStrategyFactory>();
    private List<IReconcilingStrategy> strategies = new ArrayList<IReconcilingStrategy>();
    private XtextResource resource;
    private IProgressMonitor monitor;
    private XtextEditor editor;

    @Inject
    private void initializeStrategyFactories(Injector injector) {
        ArrayList bindingsByType = injector == null ? Lists.newArrayList() : injector.findBindingsByType(TypeLiteral.get(IReconcileStrategyFactory.class));
        for (Binding binding : bindingsByType) {
            try {
                this.strategyFactories.add((IReconcileStrategyFactory)binding.getProvider().get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void reconcile(IRegion region) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reconcile region: " + region));
        }
        this.doReconcile(region);
        for (IReconcilingStrategy strategy : this.strategies) {
            strategy.reconcile(region);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setEditor(XtextEditor editor) {
        this.editor = editor;
    }

    public void setDocument(IDocument document) {
        if (!(document instanceof XtextDocument)) {
            throw new IllegalArgumentException("Document must be an " + XtextDocument.class + " but was " + document.getClass().getName());
        }
        for (IReconcilingStrategy strategy : this.strategies) {
            strategy.setDocument(document);
        }
    }

    @Override
    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.strategies.clear();
        for (IReconcileStrategyFactory factory : this.strategyFactories) {
            IReconcilingStrategy strategy = factory.createOrNull(sourceViewer);
            if (strategy == null) continue;
            this.strategies.add(strategy);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
        for (IReconcilingStrategy strategy : this.strategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)strategy).setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        for (IReconcilingStrategy strategy : this.strategies) {
            if (!(strategy instanceof IReconcilingStrategyExtension)) continue;
            ((IReconcilingStrategyExtension)strategy).initialReconcile();
        }
    }

    public void setResource(XtextResource resource) {
        this.resource = resource;
    }

    protected void doReconcile(IRegion region) {
        if (this.resource == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource is null in XtextReconcilerUnitOfWork.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        try {
            if (!(region instanceof ReconcilerReplaceRegion)) {
                throw new IllegalArgumentException("Region to be reconciled must be a ReplaceRegion");
            }
            ReconcilerReplaceRegion replaceRegionToBeProcessed = (ReconcilerReplaceRegion)region;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parsing replace region '" + (Object)((Object)replaceRegionToBeProcessed) + "'."));
            }
            this.resource.update(replaceRegionToBeProcessed.getOffset(), replaceRegionToBeProcessed.getLength(), replaceRegionToBeProcessed.getText());
            this.resource.setModificationStamp(replaceRegionToBeProcessed.getModificationStamp());
            this.postParse(this.resource, this.monitor);
        }
        catch (OperationCanceledException e) {
            this.resource.getCache().clear((Resource)this.resource);
        }
        catch (OperationCanceledError e) {
            this.resource.getCache().clear((Resource)this.resource);
        }
        catch (RuntimeException exc) {
            log.error((Object)"Parsing in reconciler failed.", (Throwable)exc);
            throw exc;
        }
    }

    protected void postParse(XtextResource resource, final IProgressMonitor monitor) throws OperationCanceledError, OperationCanceledException {
        CancelIndicator cancelIndicator = new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
        try {
            DirtyStateEditorSupport dirtyStateEditorSupport;
            EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelIndicator);
            if (this.editor != null && (dirtyStateEditorSupport = this.editor.getDirtyStateEditorSupport()) != null && !monitor.isCanceled()) {
                dirtyStateEditorSupport.announceDirtyState(resource);
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String message = this.createPostParseErrorMessage(resource);
            log.error((Object)message, (Throwable)e);
            resource.getCache().clear((Resource)resource);
        }
    }

    protected String createPostParseErrorMessage(XtextResource resource) {
        String message = "Error post-processing resource with content";
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && parseResult.getRootNode() != null) {
            message = String.valueOf(message) + ":\n" + parseResult.getRootNode().getText();
        }
        return message;
    }
}

