/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.commands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.commands.IExecutableCommandService;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IDisposable;
import org.eclipse.xtext.xbase.lib.Functions;

public class ExecutableCommandRegistry {
    private static final Logger LOG = Logger.getLogger(ExecutableCommandRegistry.class);
    private static final String METHOD = "workspace/executeCommand";
    private Multimap<String, IExecutableCommandService> registeredCommands;
    private LanguageClient client;

    public void initialize(Iterable<? extends IResourceServiceProvider> allLanguages, ClientCapabilities capabilities, LanguageClient client) {
        Boolean bl;
        ExecuteCommandCapabilities executeCommandCapabilities;
        this.client = client;
        this.registeredCommands = HashMultimap.create();
        boolean hasDynamicRegistration = false;
        WorkspaceClientCapabilities workspace = capabilities.getWorkspace();
        if (workspace != null && (executeCommandCapabilities = workspace.getExecuteCommand()) != null && (bl = executeCommandCapabilities.getDynamicRegistration()) != null) {
            hasDynamicRegistration = bl;
        }
        for (IResourceServiceProvider iResourceServiceProvider : allLanguages) {
            IExecutableCommandService service = (IExecutableCommandService)iResourceServiceProvider.get(IExecutableCommandService.class);
            if (service == null) continue;
            List<String> commands = service.initialize();
            for (String c : commands) {
                this.registeredCommands.put((Object)c, (Object)service);
            }
            if (!hasDynamicRegistration) continue;
            service.initializeDynamicRegistration((Functions.Function1<? super String, ? extends IDisposable>)((Functions.Function1)command -> this.register((String)command, service)));
        }
    }

    protected IDisposable register(String command, IExecutableCommandService service) {
        String requestId = UUID.randomUUID().toString();
        Registration reg = new Registration();
        reg.setId(requestId);
        reg.setMethod(METHOD);
        ExecuteCommandOptions executeCommandOptions = new ExecuteCommandOptions();
        executeCommandOptions.setCommands(Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{command})));
        reg.setRegisterOptions((Object)executeCommandOptions);
        RegistrationParams registrationParams = new RegistrationParams();
        registrationParams.setRegistrations((List)Lists.newArrayList((Object[])new Registration[]{reg}));
        this.client.registerCapability(registrationParams);
        this.registeredCommands.put((Object)command, (Object)service);
        return () -> {
            Unregistration unReg = new Unregistration();
            unReg.setId(requestId);
            unReg.setMethod(METHOD);
            UnregistrationParams unregistrationParams = new UnregistrationParams();
            unregistrationParams.setUnregisterations((List)Lists.newArrayList((Object[])new Unregistration[]{unReg}));
            this.client.unregisterCapability(unregistrationParams);
            this.registeredCommands.remove((Object)command, (Object)service);
        };
    }

    public Object executeCommand(ExecuteCommandParams params, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        Object result = null;
        for (IExecutableCommandService service : this.registeredCommands.get((Object)params.getCommand())) {
            Object localResult = service.execute(params, access, cancelIndicator);
            if (localResult == null) continue;
            if (result != null) {
                LOG.error((Object)("Multiple commands '" + params.getCommand() + "' have been registered. All are executed but only one result will be send back."));
                continue;
            }
            result = localResult;
        }
        return result;
    }

    public List<String> getCommands() {
        return Lists.newArrayList((Iterable)this.registeredCommands.keySet());
    }
}

