/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.depend.bcel;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.StreamUtils;
import org.apache.tools.ant.util.depend.AbstractAnalyzer;
import org.apache.tools.ant.util.depend.bcel.DependencyVisitor;

public class FullAnalyzer
extends AbstractAnalyzer {
    public FullAnalyzer() {
        block2: {
            try {
                new ClassParser("force");
            }
            catch (Exception e) {
                if (e instanceof IOException) break block2;
                throw new BuildException((Throwable)e);
            }
        }
    }

    protected void determineDependencies(Vector<File> files, Vector<String> classes) {
        int maxCount;
        HashSet<String> dependencies = new HashSet<String>();
        HashSet<File> containers = new HashSet<File>();
        HashSet toAnalyze = new HashSet(Collections.list(this.getRootClasses()));
        int count = 0;
        int n = maxCount = this.isClosureRequired() ? 1000 : 2;
        while (!toAnalyze.isEmpty() && count++ < maxCount) {
            DependencyVisitor dependencyVisitor = new DependencyVisitor();
            for (String classname : toAnalyze) {
                dependencies.add(classname);
                try {
                    File container = this.getClassContainer(classname);
                    if (container == null) continue;
                    containers.add(container);
                    ClassParser parser = container.getName().endsWith(".class") ? new ClassParser(container.getPath()) : new ClassParser(container.getPath(), classname.replace('.', '/') + ".class");
                    JavaClass javaClass = parser.parse();
                    DescendingVisitor traverser = new DescendingVisitor(javaClass, (Visitor)dependencyVisitor);
                    traverser.visit();
                }
                catch (IOException iOException) {}
            }
            toAnalyze.clear();
            StreamUtils.enumerationAsStream(dependencyVisitor.getDependencies()).filter(className -> !dependencies.contains(className)).forEach(toAnalyze::add);
        }
        files.clear();
        files.addAll(containers);
        classes.clear();
        classes.addAll(dependencies);
    }

    protected boolean supportsFileDependencies() {
        return true;
    }
}

