/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.execution.OutputManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenDiagramPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram.CoordinatesCalculator;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram.DiagramExport;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EscapeChars;
import org.polarsys.kitalpha.doc.gen.business.core.util.IDiagramHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.IFileNameService;

public class DiagramGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "\t<div>" + this.NL + "\t<p class=\"diagram-name\" id=\"";
    protected final String TEXT_2 = "\">";
    protected final String TEXT_3 = "</p>" + this.NL + "\t<p class=\"diagram\">" + this.NL + "\t\t<img id=\"";
    protected final String TEXT_4 = "\" src=\"";
    protected final String TEXT_5 = "/";
    protected final String TEXT_6 = "\" alt=\"";
    protected final String TEXT_7 = "\" usemap=\"#";
    protected final String TEXT_8 = "\" />" + this.NL + "\t\t" + this.NL + "\t\t<br/>" + this.NL + "\t\t<br/>" + this.NL + "\t\t<map name=\"";
    protected final String TEXT_9 = "\">";
    protected final String TEXT_10 = String.valueOf(this.NL) + "\t\t\t<area shape=\"rect\" group=\"";
    protected final String TEXT_11 = "\" coords=\"";
    protected final String TEXT_12 = ",";
    protected final String TEXT_13 = ",";
    protected final String TEXT_14 = ",";
    protected final String TEXT_15 = "\" href=\"../";
    protected final String TEXT_16 = "/";
    protected final String TEXT_17 = ".html#";
    protected final String TEXT_18 = "\" alt=\"";
    protected final String TEXT_19 = "\" />";
    protected final String TEXT_20 = "\t\t\t" + this.NL + "\t\t</map>" + this.NL + "\t</p>" + this.NL + "\t<p class=\"diagram-description\">";
    protected final String TEXT_21 = "</p>" + this.NL + "\t</div>";
    protected final String TEXT_22 = String.valueOf(this.NL) + "<p class=\"diagram-name\" id=\"";
    protected final String TEXT_23 = "\">";
    protected final String TEXT_24 = "</p>" + this.NL + "<p>image is missing</p>" + this.NL + "<p class=\"diagram-description\">";
    protected final String TEXT_25 = "</p>";
    protected final String TEXT_26 = this.NL;
    protected final String TEXT_27 = this.NL;
    protected String projectName = null;
    protected String outputFolder = null;
    protected DDiagram diagram = null;
    protected String generatedFolder = null;
    protected IFileNameService fileNameService = null;
    protected IDiagramHelper helper = null;

    public static synchronized DiagramGenerator create(String lineSeparator) {
        nl = lineSeparator;
        DiagramGenerator result = new DiagramGenerator();
        nl = null;
        return result;
    }

    public DiagramGenerator() {
        new StringBuffer();
    }

    public String generate(Object argument) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        InternalPatternContext ctx = (InternalPatternContext)argument;
        Node.Container currentNode = ctx.getNode();
        List projectNameList = null;
        List outputFolderList = null;
        List diagramList = null;
        List generatedFolderList = null;
        List fileNameServiceList = null;
        List helperList = null;
        for (Object projectNameParameter : projectNameList) {
            for (Object outputFolderParameter : outputFolderList) {
                for (Object diagramParameter : diagramList) {
                    for (Object generatedFolderParameter : generatedFolderList) {
                        for (Object fileNameServiceParameter : fileNameServiceList) {
                            for (Object helperParameter : helperList) {
                                this.projectName = (String)projectNameParameter;
                                this.outputFolder = (String)outputFolderParameter;
                                this.diagram = (DDiagram)diagramParameter;
                                this.generatedFolder = (String)generatedFolderParameter;
                                this.fileNameService = (IFileNameService)fileNameServiceParameter;
                                this.helper = (IDiagramHelper)helperParameter;
                                if (!this.preCondition((PatternContext)ctx)) continue;
                                ctx.setNode(new Node.Container(currentNode, this.getClass()));
                                this.orchestration((PatternContext)ctx);
                            }
                        }
                    }
                }
            }
        }
        ctx.setNode(currentNode);
        if (ctx.useReporter()) {
            ctx.getReporter().executionFinished(OutputManager.computeExecutionOutput((PatternContext)ctx), (PatternContext)ctx);
        }
        stringBuffer.append(this.TEXT_26);
        stringBuffer.append(this.TEXT_27);
        return stringBuffer.toString();
    }

    public String orchestration(PatternContext ctx) throws Exception {
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        this.method_body(new StringBuffer(), (PatternContext)ictx);
        if (ictx.useReporter()) {
            HashMap<String, Object> parameterValues = new HashMap<String, Object>();
            parameterValues.put("projectName", this.projectName);
            parameterValues.put("outputFolder", this.outputFolder);
            parameterValues.put("diagram", this.diagram);
            parameterValues.put("generatedFolder", this.generatedFolder);
            parameterValues.put("fileNameService", this.fileNameService);
            parameterValues.put("helper", this.helper);
            String outputWithCallBack = OutputManager.computeLoopOutput((PatternContext)ictx);
            String loop = OutputManager.computeLoopOutputWithoutCallback((PatternContext)ictx);
            ictx.getReporter().loopFinished(loop, outputWithCallBack, (PatternContext)ictx, parameterValues);
        }
        return null;
    }

    public void set_projectName(String object) {
        this.projectName = object;
    }

    public void set_outputFolder(String object) {
        this.outputFolder = object;
    }

    public void set_diagram(DDiagram object) {
        this.diagram = object;
    }

    public void set_generatedFolder(String object) {
        this.generatedFolder = object;
    }

    public void set_fileNameService(IFileNameService object) {
        this.fileNameService = object;
    }

    public void set_helper(IDiagramHelper object) {
        this.helper = object;
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("projectName", this.projectName);
        parameters.put("outputFolder", this.outputFolder);
        parameters.put("diagram", this.diagram);
        parameters.put("generatedFolder", this.generatedFolder);
        parameters.put("fileNameService", this.fileNameService);
        parameters.put("helper", this.helper);
        return parameters;
    }

    protected void method_body(StringBuffer stringBuffer, PatternContext ctx) throws Exception {
        Session session = DiagramSessionHelper.getCurrentSession();
        IPath outputPath = new Path(this.projectName).append(this.outputFolder).append(this.generatedFolder);
        DiagramExport diagramExport = new DiagramExport(this.projectName, outputPath, this.diagram, session);
        IFile imageFile = diagramExport.exportAsImage();
        Resource sessionResource = session.getSessionResource();
        if (imageFile != null && imageFile.exists()) {
            String id = DiagramSessionHelper.getID((EObject)this.diagram);
            String mapName = String.valueOf(this.diagram.getName()) + "_" + id + "_PositionMap";
            mapName = DocGenHtmlUtil.getValidFileName(mapName);
            CoordinatesCalculator calculator = new CoordinatesCalculator(imageFile, this.diagram, this.helper);
            Map<Rectangle, EObject> positionMap = calculator.getPositionMap();
            stringBuffer.append(this.TEXT_1);
            stringBuffer.append(id);
            stringBuffer.append("\">");
            stringBuffer.append(EscapeChars.forHTML(this.diagram.getName()));
            stringBuffer.append(this.TEXT_3);
            stringBuffer.append(this.diagram.hashCode());
            stringBuffer.append("\" src=\"");
            stringBuffer.append(this.generatedFolder);
            stringBuffer.append("/");
            stringBuffer.append(imageFile.getName());
            stringBuffer.append("\" alt=\"");
            stringBuffer.append(EscapeChars.forHTML(this.diagram.getName()));
            stringBuffer.append("\" usemap=\"#");
            stringBuffer.append(mapName);
            stringBuffer.append(this.TEXT_8);
            stringBuffer.append(mapName);
            stringBuffer.append("\">");
            String fragment = null;
            String fileName = null;
            String modelName = null;
            for (Map.Entry<Rectangle, EObject> entrySet : positionMap.entrySet()) {
                EObject value = entrySet.getValue();
                Rectangle rectangle = entrySet.getKey();
                Point topLeft = rectangle.getTopLeft();
                Point bottomRight = rectangle.getBottomRight();
                fragment = null;
                fileName = null;
                modelName = null;
                if (value instanceof DRepresentationDescriptor) {
                    DRepresentationDescriptor descriptor = (DRepresentationDescriptor)value;
                    DDiagram targetDiagram = DiagramSessionHelper.getDDiagram(descriptor);
                    fragment = targetDiagram != null ? DiagramSessionHelper.getID((EObject)targetDiagram) : descriptor.getRepPath().getResourceURI().fragment();
                    fileName = this.fileNameService.getFileName(descriptor.getTarget());
                    modelName = DocGenHtmlUtil.getModelName(descriptor.getTarget());
                } else {
                    fileName = this.fileNameService.getFileName(value);
                    fragment = this.helper.getElementId(value);
                    rectangle = entrySet.getKey();
                    topLeft = rectangle.getTopLeft();
                    bottomRight = rectangle.getBottomRight();
                    modelName = DocGenHtmlUtil.getModelName(value);
                }
                stringBuffer.append(this.TEXT_10);
                stringBuffer.append(fileName);
                stringBuffer.append("\" coords=\"");
                stringBuffer.append(topLeft.x);
                stringBuffer.append(",");
                stringBuffer.append(topLeft.y);
                stringBuffer.append(",");
                stringBuffer.append(bottomRight.x);
                stringBuffer.append(",");
                stringBuffer.append(bottomRight.y);
                stringBuffer.append("\" href=\"../");
                stringBuffer.append(modelName);
                stringBuffer.append("/");
                stringBuffer.append(fileName);
                stringBuffer.append(".html#");
                stringBuffer.append(fragment);
                stringBuffer.append("\" alt=\"");
                stringBuffer.append(fileName);
                stringBuffer.append("\" />");
            }
            stringBuffer.append(this.TEXT_20);
            stringBuffer.append(this.helper.diagramDocumentationPostTraitement(((DSemanticDiagram)this.diagram).getTarget(), this.diagram.getDocumentation(), this.projectName, this.outputFolder));
            stringBuffer.append(this.TEXT_21);
        } else {
            String diagramName = this.diagram.getName();
            if (diagramName != null && !diagramName.isEmpty()) {
                diagramName = EscapeChars.forHTML(diagramName);
            }
            stringBuffer.append(this.TEXT_22);
            stringBuffer.append(sessionResource.getURIFragment((EObject)this.diagram));
            stringBuffer.append("\">");
            stringBuffer.append(diagramName);
            stringBuffer.append(this.TEXT_24);
            stringBuffer.append(this.diagram.getDocumentation());
            stringBuffer.append("</p>");
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", "Error during diagram export action:" + this.diagram.getName()));
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "body", stringBuffer.toString());
    }

    public boolean preCondition(PatternContext ctx) throws Exception {
        return DocgenDiagramPreferencesHelper.getExportDiagram();
    }
}

