/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.viewer;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.TreePatternFilter;
import org.polarsys.capella.core.data.capellacore.CapellaElement;

public class CapellaNavigatorPatternFilter
extends TreePatternFilter {
    private boolean searchInDescription;

    protected String getTextFromModelElement(EObject element) {
        String result = null;
        if (this.searchInDescription) {
            if (element instanceof CapellaElement) {
                result = ((CapellaElement)element).getDescription();
            } else if (element instanceof DSemanticDiagram) {
                result = ((DSemanticDiagram)element).getDocumentation();
            }
        } else {
            result = super.getTextFromModelElement(element);
        }
        return result == null ? "" : result;
    }

    public boolean isElementVisible(Viewer viewer, Object parentElement, Object element) {
        if (this.searchInDescription) {
            return this.isLeafMatch(viewer, parentElement, element) || this.isParentMatch(viewer, parentElement, element);
        }
        boolean visible = super.isElementVisible(viewer, parentElement, element);
        return visible;
    }

    protected boolean isLeafMatch(Viewer viewer, Object parentElement, Object element) {
        if (this.searchInDescription) {
            return this.doIsLeafMatch(viewer, parentElement, element);
        }
        return super.isLeafMatch(viewer, parentElement, element);
    }

    protected boolean isParentMatch(Viewer viewer, Object parentElement, Object element) {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)((StructuredViewer)viewer).getContentProvider();
        Object[] children = iTreeContentProvider.getChildren(element);
        if (children != null && children.length > 0) {
            return this.isAnyVisible(viewer, element, children);
        }
        return false;
    }

    protected boolean isSearchingInDescription() {
        return this.searchInDescription;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchInDescription) {
            return this.isElementVisible(viewer, parentElement, element);
        }
        return super.select(viewer, parentElement, element);
    }

    protected void setSearchInDescription(boolean newSearchInDescription) {
        this.searchInDescription = newSearchInDescription;
    }
}

