/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ContractMode implements Enumerator
{
    IN(0, "In", "In"),
    OUT(1, "Out", "Out"),
    IN_OUT(2, "In_Out", "In_Out");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int IN_OUT_VALUE = 2;
    private static final ContractMode[] VALUES_ARRAY;
    public static final List<ContractMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContractMode[]{IN, OUT, IN_OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContractMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContractMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContractMode get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return IN_OUT;
            }
        }
        return null;
    }

    private ContractMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

