/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.ui.domain;

import java.util.Collection;
import org.eclipse.egf.domain.Activator;
import org.eclipse.egf.domain.DomainException;
import org.eclipse.egf.domain.LoadableDomainHelper;
import org.eclipse.egf.domain.Messages;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.LoadableDomain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeException;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;

public class CapellaDomainHelper
extends LoadableDomainHelper {
    private ResourceSet getResourcesSet(URI resourceURI) {
        for (TransactionalEditingDomain transactionalEditingDomain : ExecutionManagerRegistry.getInstance().getAllEditingDomains()) {
            Project project;
            EList ownedModelRoots;
            EObject modelRoot;
            Resource resource = transactionalEditingDomain.getResourceSet().getResource(resourceURI, false);
            if (resource == null || resource.getContents().isEmpty() || (modelRoot = (EObject)resource.getContents().get(0)) == null || !(modelRoot instanceof Project) || (ownedModelRoots = (project = (Project)modelRoot).getOwnedModelRoots()) == null || ownedModelRoots.isEmpty()) continue;
            return transactionalEditingDomain.getResourceSet();
        }
        return null;
    }

    protected boolean doLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof EMFDomain) {
            EMFDomain myDomain = (EMFDomain)domain;
            if (myDomain.isLoaded()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            myDomain.setLoaded(true);
            GenerationGlobalScope globalScope = GenerationGlobalScope.getInstance();
            if (globalScope.getReferencesStrategy().equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
                try {
                    EList generationScope = globalScope.getScopedResource().getContents();
                    myDomain.getContent().addAll((Collection)generationScope);
                }
                catch (ScopeException e) {
                    throw new DomainException((Throwable)e);
                }
            }
            URI uri = myDomain.getUri();
            if (uri == null || "".equals(uri.toString())) {
                Activator.getDefault().logWarning(Messages.bind((String)Messages.Load_EMFDomain_error1, (Object)domain.getName()));
                return true;
            }
            ResourceSet set = this.getResourcesSet(myDomain.getUri());
            Resource domainResource = null;
            try {
                domainResource = set.getResource(uri, true);
            }
            catch (Exception e) {
                throw new DomainException((Throwable)e);
            }
            if (!myDomain.getContent().isEmpty()) {
                throw new DomainException(Messages.bind((String)Messages.Load_Domain_error1, (Object)domain.eClass().getName(), (Object)domain.getName()));
            }
            EList contents = domainResource.getContents();
            myDomain.getContent().addAll((Collection)contents);
            return true;
        }
        return false;
    }

    protected boolean doUnLoadDomain(LoadableDomain domain) throws DomainException {
        if (domain instanceof EMFDomain) {
            EMFDomain myDomain = (EMFDomain)domain;
            if (!myDomain.getContent().isEmpty()) {
                myDomain.getContent().clear();
                myDomain.setLoaded(false);
            }
            return true;
        }
        return false;
    }
}

