/*
 * Decompiled with CFR 0.152.
 */
package ms.configuration.services.cs;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ms.configuration.services.cs.Images;
import ms.configuration.services.cs.Messages;
import ms.configuration.services.cs.MsMappingConstants;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.EdgeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.description.InstanceRoleMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.MsFactory;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.expression.parser.LinkedText2Situation;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionUnparser;
import org.polarsys.capella.vp.ms.provider.MsEditPlugin;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CsConfigurationServices {
    public static final String DANNOTATION_SOURCE = "http://polarsys.org/capella/vp/ms";
    public static final String DANNOTATION_DETAIL_SHOW_CHILD_RELATIONS = "showChildRelations";
    public static final String DANNOTATION_DETAIL_SHOW_COMPONENTS = "showComponents";
    public static final String DANNOTATION_DETAIL_SHOW_FUNCTIONS = "showFunctions";
    public static final String DANNOTATION_DETAIL_SHOW_PORTS = "showPorts";
    public static final String DANNOTATION_DETAIL_SHOW_FUNCTIONAL_CHAINS = "showFunctionalChains";
    public static final String DANNOTATION_DETAIL_SHOW_SCENARIOS = "showScenarios";
    public static final String DANNOTATION_DETAIL_SHOW_FUNCTIONAL_EXCHANGES = "showFunctionalExchanges";
    public static final String DANNOTATION_DETAIL_SHOW_COMPONENT_EXCHANGES = "showComponentExchanges";
    public static final String DANNOTATION_DETAIL_SHOW_PHYSICAL_LINKS = "showPhysicalLinks";
    private static final String CONFIGURATIONS_LAYER_LABEL = Messages.CsConfigurationServices_Configurations_Layer_Name;
    private static final Predicate<Component> HAS_STATEMACHINE = new Predicate<Component>(){

        @Override
        public boolean test(Component t) {
            return t.getOwnedStateMachines().size() > 0;
        }
    };
    protected List<CSConfiguration> configListFiltered = new ArrayList<CSConfiguration>();
    protected List<CSConfiguration> configList = new ArrayList<CSConfiguration>();

    private Map<CSConfiguration, DNode> getCurrentConfigNodeMap(DDiagram diagram) {
        HashMap<CSConfiguration, DNode> current = new HashMap<CSConfiguration, DNode>();
        for (DNode node : diagram.getNodes()) {
            if (!(node.getTarget() instanceof CSConfiguration)) continue;
            current.put((CSConfiguration)node.getTarget(), node);
        }
        return current;
    }

    private boolean isWizardCancelled(Object selection) {
        return "WIZARD_CANCELED".equals(selection);
    }

    public boolean msConfigurationElementsTablePrecondition(EObject element) {
        return element instanceof ComponentPkg || element instanceof Component;
    }

    public EObject msShowHideScenarioConfigurationsTool(Scenario sc, SequenceDDiagram diagram, Object selection) {
        return this.msShowHideScenarioConfigurationsTool(sc, diagram, null, null, selection);
    }

    public EObject msShowHideScenarioConfigurationsTool(InstanceRole ir, DNode irNode, Object selection) {
        return this.msShowHideScenarioConfigurationsTool((Scenario)ir.eContainer(), (SequenceDDiagram)irNode.getParentDiagram(), ir, irNode, selection);
    }

    private EObject msShowHideScenarioConfigurationsTool(Scenario scenario, SequenceDDiagram diagram, InstanceRole ir, DNode irNode, Object selection) {
        if (!this.isWizardCancelled(selection)) {
            Session session = SessionManager.INSTANCE.getSession((EObject)diagram);
            Map<CSConfiguration, DNode> shown = this.getCurrentConfigNodeMap((DDiagram)diagram);
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)diagram);
            for (Object t : (Iterable)selection) {
                DNode node = shown.remove(t);
                if (node == null) {
                    NodeMapping nodeMapping = MsMappingConstants.getConfigurationNodeMapping(diagram);
                    node = new NodeMappingHelper(interpreter).createNode((INodeMappingExt)nodeMapping, (EObject)((CSConfiguration)t), (EObject)diagram, (DDiagram)diagram);
                    diagram.getOwnedDiagramElements().add((Object)node);
                }
                if (ir == null) {
                    for (DEdge in : node.getIncomingEdges()) {
                        if (!(in.getSourceNode() instanceof DSemanticDecorator) || !(in.getTarget() instanceof InstanceRole)) continue;
                        EcoreUtil.remove((EObject)in);
                    }
                    continue;
                }
                EdgeMapping edgeMapping = MsMappingConstants.getInstanceRoleConfigurationEdgeMapping(diagram);
                DEdge edge = new EdgeMappingHelper(interpreter).createEdge(edgeMapping, (EdgeTarget)irNode, (EdgeTarget)node, (EObject)diagram, (EObject)ir);
                diagram.getOwnedDiagramElements().add((Object)edge);
            }
            for (Map.Entry entry : shown.entrySet()) {
                DEdge deleteEdge = null;
                boolean hasMoreEdges = false;
                for (DEdge incoming : ((DNode)entry.getValue()).getIncomingEdges()) {
                    if (!(incoming.getSourceNode() instanceof DSemanticDecorator) || !(((DSemanticDecorator)incoming.getSourceNode()).getTarget() instanceof InstanceRole)) continue;
                    if (incoming.getSourceNode() == irNode) {
                        deleteEdge = incoming;
                        continue;
                    }
                    hasMoreEdges = true;
                }
                if (irNode != null) {
                    if (deleteEdge == null) continue;
                    EcoreUtil.remove(deleteEdge);
                    if (hasMoreEdges) continue;
                    EcoreUtil.remove((EObject)((EObject)entry.getValue()));
                    continue;
                }
                if (hasMoreEdges) continue;
                EcoreUtil.remove((EObject)((EObject)entry.getValue()));
            }
        }
        return scenario;
    }

    public Collection<CSConfiguration> msScenarioInstanceRoleConfigurationFinder(InstanceRole context) {
        return this.getAllBlockConfigurationsSemantic((EObject)context);
    }

    public boolean msScenarioConfigurationSelectionPrecondition(EObject context) {
        boolean result = false;
        if (context instanceof DNode) {
            EObject semantic = ((DNode)context).getTarget();
            if (semantic instanceof InstanceRole && ((DNode)context).getActualMapping() instanceof InstanceRoleMapping) {
                result = true;
            }
        } else if (context instanceof SequenceDDiagram) {
            result = true;
        }
        return result;
    }

    public static boolean canCompleteChildConfigurationRelation(CSConfiguration source, CSConfiguration target) {
        AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)source);
        IItemPropertySource propertySource = (IItemPropertySource)domain.getAdapterFactory().adapt((Notifier)source, IItemPropertySource.class);
        return propertySource.getPropertyDescriptor((Object)source, (Object)MsPackage.Literals.CS_CONFIGURATION__CHILD_CONFIGURATIONS).getChoiceOfValues((Object)source).contains(target);
    }

    public Collection<EObject> getIrregularEObject(EObject ele) {
        ArrayList<EObject> objectsIrregularList = new ArrayList<EObject>();
        return objectsIrregularList;
    }

    public Collection<CSConfiguration> getOwnedConfigurations(EObject ele) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        Type e = null;
        if (ele instanceof Part) {
            e = ((Part)ele).getType();
        } else if (ele instanceof ExtensibleElement) {
            e = (ExtensibleElement)ele;
        }
        if (e != null) {
            for (ElementExtension extension : e.getOwnedExtensions()) {
                if (!(extension instanceof CSConfiguration)) continue;
                result.add((CSConfiguration)extension);
            }
        }
        return result;
    }

    public List<EObject> getConfigurationFromElement(EObject ele) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)ele);
        Collection increfs = domain.getCrossReferencer().getInverseReferences(ele, MsPackage.Literals.CS_CONFIGURATION__INCLUDED, true);
        Collection excrefs = domain.getCrossReferencer().getInverseReferences(ele, MsPackage.Literals.CS_CONFIGURATION__EXCLUDED, true);
        UniqueEList result = new UniqueEList(increfs.size() + excrefs.size());
        for (EStructuralFeature.Setting setting : increfs) {
            result.add(setting.getEObject());
        }
        for (EStructuralFeature.Setting setting : excrefs) {
            result.add(setting.getEObject());
        }
        return result;
    }

    public Collection<EObject> getConfigurationsFromMode(AbstractState state) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)state);
        Collection refs = domain.getCrossReferencer().getInverseReferences((EObject)state, MsPackage.Literals.CS_CONFIGURATION__SUPPORTED_MODES, true);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : refs) {
            result.add(setting.getEObject());
        }
        return result;
    }

    public Collection<EObject> getConfigurationsFromEObject(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(ele);
        return result;
    }

    public Collection<EObject> getConfigurationsFromModesandStates(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(ele);
        return result;
    }

    public static boolean isConfigurationsLayerActive(DDiagram diag) {
        for (Layer l : diag.getActivatedLayers()) {
            if (!CONFIGURATIONS_LAYER_LABEL.equals(l.getLabel())) continue;
            return true;
        }
        return false;
    }

    private void getSelectedConfigurationsImpl(AbstractDNode view, boolean includeParents, Collection<CSConfiguration> result) {
        AbstractDNode current = view;
        for (DNode dNode : current.getOwnedBorderedNodes()) {
            if (!(dNode.getTarget() instanceof CSConfiguration)) continue;
            result.add((CSConfiguration)dNode.getTarget());
        }
        if (view.getTarget() instanceof InstanceRole) {
            for (DEdge edge : ((EdgeTarget)view).getOutgoingEdges()) {
                if (!(edge.getTargetNode() instanceof DNode) || !(((DNode)edge.getTargetNode()).getTarget() instanceof CSConfiguration)) continue;
                result.add((CSConfiguration)((DNode)edge.getTargetNode()).getTarget());
            }
        }
        if (includeParents) {
            if (current.eContainer() instanceof AbstractDNode) {
                this.getSelectedConfigurationsImpl((AbstractDNode)current.eContainer(), includeParents, result);
            } else if (current.eContainer() instanceof DSemanticDiagram) {
                this.getSelectedConfigurationsImpl((DSemanticDiagram)current.eContainer(), result);
            }
        }
    }

    public Collection<CSConfiguration> getSelectedConfigurations(AbstractDNode view, boolean includeParents) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        this.getSelectedConfigurationsImpl(view, includeParents, result);
        return result;
    }

    public Collection<CSConfiguration> getSelectedConfigurations(DSemanticDiagram diagram) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        this.getSelectedConfigurationsImpl(diagram, result);
        return result;
    }

    public Collection<CSConfiguration> getSelectedConfigurations(AbstractDNode node) {
        return this.getSelectedConfigurations(node, false);
    }

    private void getSelectedConfigurationsImpl(DSemanticDiagram diagram, Collection<CSConfiguration> result) {
        for (DDiagramElement de : diagram.getOwnedDiagramElements()) {
            if (!(de.getTarget() instanceof CSConfiguration) || de instanceof DEdge) continue;
            boolean include = true;
            if (de instanceof EdgeTarget) {
                for (DEdge edge : ((EdgeTarget)de).getIncomingEdges()) {
                    if (!(edge.getSourceNode() instanceof DSemanticDecorator) || !(((DSemanticDecorator)edge.getSourceNode()).getTarget() instanceof InstanceRole)) continue;
                    include = false;
                }
            }
            if (!include) continue;
            result.add((CSConfiguration)de.getTarget());
        }
    }

    public List<EObject> getNotSelectedConfigurations(EObject view, List<EObject> selection) {
        if (view instanceof DNodeContainer) {
            return this.getNotSelectedConfigurations((DNodeContainer)view, selection);
        }
        if (view instanceof DDiagram) {
            return this.getNotSelectedConfigurations((DDiagram)view, selection);
        }
        throw new IllegalArgumentException();
    }

    private List<EObject> getNotSelectedConfigurations(DNodeContainer view, List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DNode dNode : view.getOwnedBorderedNodes()) {
            if (!(dNode.getTarget() instanceof CSConfiguration) || selection.contains(dNode.getTarget())) continue;
            result.add((EObject)dNode);
        }
        return result;
    }

    private List<EObject> getNotSelectedConfigurations(DDiagram diagram, List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement element : diagram.getOwnedDiagramElements()) {
            if (!(element.getTarget() instanceof CSConfiguration) || selection.contains(element.getTarget())) continue;
            result.add((EObject)element);
        }
        return result;
    }

    public Collection<CSConfiguration> getSelectableConfigurations(DSemanticDiagram diagram) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        EObject c = diagram.getTarget();
        while (c instanceof Component || c instanceof ComponentPkg) {
            result.addAll(this.getOwnedConfigurations(c));
            c = c.eContainer();
        }
        return result;
    }

    public Collection<CSConfiguration> getAllBlockConfigurationsSemantic(EObject semantic) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)semantic);
        if (ba != null) {
            result.addAll(EObjectExt.getAll((EObject)ba, (EClass)MsPackage.Literals.CS_CONFIGURATION));
        }
        return result;
    }

    public Collection<CSConfiguration> getAllBlockConfigurations(DSemanticDecorator decorator) {
        return this.getAllBlockConfigurationsSemantic(decorator.getTarget());
    }

    public boolean isDiagram(EObject e) {
        return e instanceof DSemanticDiagram;
    }

    public Collection<CSConfiguration> getSelectableConfigurations(DNodeContainer container) {
        Collection<CSConfiguration> result = Collections.emptyList();
        Component comp = null;
        if (container.getTarget() instanceof Component) {
            comp = (Component)container.getTarget();
        } else if (container.getTarget() instanceof Part && ((Part)container.getTarget()).getType() instanceof Component) {
            comp = (Component)((Part)container.getTarget()).getType();
        }
        if (comp != null) {
            result = this.getOwnedConfigurations((EObject)comp);
        }
        return result;
    }

    public boolean msStyleCustomizationPredicate(ModelElement context, DDiagramElement view) {
        return false;
    }

    public int disabledElementColor(ModelElement context, DDiagramElement view) {
        boolean isComponent = (context instanceof Part ? ((Part)context).getType() : context) instanceof Component;
        if (isComponent) {
            return 200;
        }
        return 220;
    }

    public static boolean isConsistentIncludeRequired() {
        return Platform.getPreferencesService().getBoolean("org.polarsys.capella.vp.ms.ui.preferences", "defaultConsistentIncludeRequired", true, null);
    }

    public static boolean isMarkConflictingInclusions() {
        return Platform.getPreferencesService().getBoolean("org.polarsys.capella.vp.ms.ui.preferences", "defaultMarkConflicts", true, null);
    }

    public boolean isShowDisabledPortOverlay(ModelElement context, DDiagramElement view) {
        throw new UnsupportedOperationException("Overlays not working with Capella 1.2.1, see https://bugs.polarsys.org/show_bug.cgi?id=2115");
    }

    public int disabledElementLabelColor(ModelElement context, DDiagramElement view) {
        return 120;
    }

    public String disabledElementWorkspacePathImage(ModelElement context, DDiagramElement view) {
        return Images.getImagePath((EObject)context, view);
    }

    public CSConfiguration createConfiguration(EObject context) {
        Component cmp = null;
        if (context instanceof Component) {
            cmp = (Component)context;
        } else if (context instanceof Part && ((Part)context).getType() instanceof Component) {
            cmp = (Component)((Part)context).getType();
        } else if (context instanceof ComponentPkg) {
            cmp = (ComponentPkg)context;
        } else {
            BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)context);
            cmp = BlockArchitectureExt.getComponentPkg((BlockArchitecture)ba);
        }
        if (cmp != null) {
            CSConfiguration configuration = MsFactory.eINSTANCE.createCSConfiguration();
            cmp.getOwnedExtensions().add((Object)configuration);
            this.msCreationService(configuration);
            return configuration;
        }
        return null;
    }

    public boolean canEditStateConfiguration(EObject state) {
        return !(state instanceof FinalState);
    }

    public List<AbstractFunction> getAllocatedFunctions(EObject component) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        if (component instanceof Component) {
            result.addAll((Collection<AbstractFunction>)((Component)component).getAllocatedFunctions());
        }
        return result;
    }

    public String msCrossTableLabel(CSConfiguration c, EObject element) {
        if (c.getIncluded().contains((Object)element)) {
            if (c.getExcluded().contains((Object)element)) {
                return "E, I";
            }
            return "I";
        }
        if (c.getExcluded().contains((Object)element)) {
            return "E";
        }
        return "";
    }

    public Collection<?> msCrossTableFunctionalChains(DTable table, EObject component) {
        if (CsConfigurationServices.isShowFunctionalChains(table)) {
            return this.msCrossTableElements(table, component, FaPackage.Literals.FUNCTIONAL_CHAIN);
        }
        return Collections.emptyList();
    }

    public Collection<?> msCrossTableFunctionalExchanges(DTable table, EObject component) {
        if (CsConfigurationServices.isShowFunctionalExchanges(table)) {
            return this.msCrossTableElements(table, component, FaPackage.Literals.FUNCTIONAL_EXCHANGE);
        }
        return Collections.emptyList();
    }

    public Collection<?> msCrossTableComponentExchanges(DTable table, EObject component) {
        if (CsConfigurationServices.isShowComponentExchanges(table)) {
            return this.msCrossTableElements(table, component, FaPackage.Literals.COMPONENT_EXCHANGE);
        }
        return Collections.emptyList();
    }

    public Collection<?> msCrossTablePhysicalLinks(DTable table, EObject component) {
        if (CsConfigurationServices.isShowPhysicalLinks(table)) {
            return this.msCrossTableElements(table, component, CsPackage.Literals.PHYSICAL_LINK);
        }
        return Collections.emptyList();
    }

    public Collection<?> msCrossTableScenarios(DTable table, EObject component) {
        if (CsConfigurationServices.isShowScenarios(table)) {
            return this.msCrossTableElements(table, component, InteractionPackage.Literals.SCENARIO);
        }
        return Collections.emptyList();
    }

    private Collection<?> msCrossTableElements(DTable table, EObject component, EClass clazz) {
        if (this.getOwnedConfigurations(component).isEmpty()) {
            return Collections.emptyList();
        }
        CSConfiguration configuration = this.getOwnedConfigurations(component).iterator().next();
        AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)configuration);
        IItemPropertySource propertySource = (IItemPropertySource)domain.getAdapterFactory().adapt((Notifier)configuration, IItemPropertySource.class);
        IItemPropertyDescriptor descriptor = propertySource.getPropertyDescriptor((Object)configuration, (Object)MsPackage.Literals.CS_CONFIGURATION__INCLUDED);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (Object o : descriptor.getChoiceOfValues((Object)configuration)) {
            if (!clazz.isInstance(o)) continue;
            result.add((EObject)o);
        }
        return result;
    }

    public void msCreationService(CSConfiguration configuration) {
        CapellaElementExt.creationService((EObject)configuration, (String)MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_type"));
    }

    public Collection<InputPin> msInputs(DTable table, AbstractFunction function) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return function.getInputs();
        }
        return Collections.emptyList();
    }

    public Collection<OutputPin> msOutputs(DTable table, AbstractFunction function) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return function.getOutputs();
        }
        return Collections.emptyList();
    }

    public Collection<AbstractFunction> msAllocatedFunctions(DTable table, Component component) {
        if (CsConfigurationServices.isShowFunctions(table)) {
            return component.getAllocatedFunctions();
        }
        return Collections.emptyList();
    }

    public Collection<? extends EObject> msCrossTableComponentLines(LogicalComponent c) {
        return c.getOwnedLogicalComponents();
    }

    public Collection<? extends EObject> msCrossTableComponentLines(LogicalComponentPkg p) {
        return p.getOwnedLogicalComponents();
    }

    public Collection<? extends EObject> msCrossTableComponentLines(PhysicalComponentPkg p) {
        return p.getOwnedPhysicalComponents();
    }

    public Collection<? extends EObject> msCrossTableComponentLines(SystemComponentPkg p) {
        return p.getOwnedSystemComponents();
    }

    public Collection<? extends EObject> msCrossTableComponentLines(Entity e) {
        return e.getOwnedEntities();
    }

    public Collection<? extends EObject> msCrossTableComponentLines(EntityPkg p) {
        return p.getOwnedEntities();
    }

    public Collection<? extends EObject> msContainedComponentPorts(DTable table, Component component) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return component.getContainedComponentPorts();
        }
        return Collections.emptyList();
    }

    public Collection<PhysicalPort> msContainedPhysicalPorts(DTable table, Component component) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return component.getContainedPhysicalPorts();
        }
        return Collections.emptyList();
    }

    public Collection<ComponentPkg> msComponentRoot(DTable table, ComponentPkg pkg) {
        if (CsConfigurationServices.isShowComponents(table)) {
            return Collections.singletonList(pkg);
        }
        return Collections.emptyList();
    }

    public Collection<Component> msComponentRoot(DTable table, Component component) {
        if (CsConfigurationServices.isShowComponents(table)) {
            return Collections.singletonList(component);
        }
        return Collections.emptyList();
    }

    private void createChildConfigurationEdge(DDiagram diagram, EdgeTarget source, EdgeTarget target) {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)diagram);
        EdgeMapping edgeMapping = MsMappingConstants.getChildConfigurationMapping(diagram);
        DEdge edge = new EdgeMappingHelper(interpreter).createEdge(edgeMapping, source, target, (EObject)diagram, null);
        diagram.getOwnedDiagramElements().add((Object)edge);
    }

    public void msToggleChildConfigurationEdges(DDiagramElement diagramElement) {
        this.msToggleChildConfigurationEdges((DSemanticDiagram)diagramElement.getParentDiagram());
    }

    public void msToggleChildConfigurationEdges(DSemanticDiagram diagram) {
        Session session = SessionManager.INSTANCE.getSession(diagram.getTarget());
        ECrossReferenceAdapter xref = session != null ? session.getSemanticCrossReferencer() : null;
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)diagram);
        ArrayList<DDiagramElement> delete = new ArrayList<DDiagramElement>();
        for (DDiagramElement e2 : diagram.getOwnedDiagramElements()) {
            if (!(e2 instanceof DEdge) || !(e2.getTarget() instanceof CSConfiguration)) continue;
            delete.add(e2);
        }
        if (delete.size() > 0) {
            delete.forEach(e -> accessor.eDelete(e, xref));
            return;
        }
        HashMap<CSConfiguration, EdgeTarget> map = new HashMap<CSConfiguration, EdgeTarget>();
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (next instanceof DEdge || !(next instanceof EdgeTarget) || !(next instanceof DSemanticDecorator) || !(((DSemanticDecorator)next).getTarget() instanceof CSConfiguration)) continue;
            map.put((CSConfiguration)((DSemanticDecorator)next).getTarget(), (EdgeTarget)next);
        }
        for (Map.Entry entry : map.entrySet()) {
            for (CSConfiguration child : ((CSConfiguration)entry.getKey()).getChildConfigurations()) {
                EdgeTarget target = (EdgeTarget)map.get(child);
                if (target == null) continue;
                this.createChildConfigurationEdge((DDiagram)diagram, (EdgeTarget)entry.getValue(), (EdgeTarget)map.get(child));
            }
        }
    }

    public static void setShowComponents(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_COMPONENTS, b);
    }

    public static boolean isShowFunctionalExchanges(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONAL_EXCHANGES, true);
    }

    public static void setShowFunctionalExchanges(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONAL_EXCHANGES, b);
    }

    public static boolean isShowComponentExchanges(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_COMPONENT_EXCHANGES, true);
    }

    public static void setShowComponentExchanges(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_COMPONENT_EXCHANGES, b);
    }

    public static boolean isShowPhysicalLinks(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_PHYSICAL_LINKS, true);
    }

    public static void setShowPhysicalLinks(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_PHYSICAL_LINKS, b);
    }

    public static boolean isShowComponents(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_COMPONENTS, true);
    }

    public static void setShowFunctions(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONS, b);
    }

    public static boolean isShowFunctions(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONS, true);
    }

    public static void setShowPorts(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_PORTS, b);
    }

    public static boolean isShowPorts(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_PORTS, true);
    }

    public static void setShowFunctionalChains(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONAL_CHAINS, b);
    }

    public static boolean isShowFunctionalChains(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONAL_CHAINS, true);
    }

    public static boolean isShowScenarios(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_SCENARIOS, true);
    }

    public static void setShowScenarios(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_SCENARIOS, b);
    }

    private static boolean isAnnotationDetailSet(DModelElement element, String key, boolean defaultValue) {
        DAnnotation annot = CsConfigurationServices.getAnnotation(element, DANNOTATION_SOURCE, false);
        if (annot != null && annot.getDetails().containsKey((Object)key)) {
            return Boolean.valueOf((String)annot.getDetails().get((Object)key));
        }
        return defaultValue;
    }

    private static void setAnnotationDetail(DModelElement element, String key, boolean value) {
        DAnnotation annot = CsConfigurationServices.getAnnotation(element, DANNOTATION_SOURCE, true);
        annot.getDetails().put((Object)key, (Object)String.valueOf(value));
    }

    private static DAnnotation getAnnotation(DModelElement element, String source, boolean create) {
        DAnnotation result = element.getDAnnotation(source);
        if (result == null && create) {
            result = DescriptionFactory.eINSTANCE.createDAnnotation();
            result.setSource(source);
            element.getEAnnotations().add((Object)result);
        }
        return result;
    }

    public boolean msConfigurationNodeCreationPrecondition(EObject container) {
        return container instanceof Component | container instanceof Part;
    }

    public String msSituationExpression(StateMachine row, Situation situation, DLine line, DColumn column) {
        LinkedText2Situation.SplitExpression split = LinkedText2Situation.SplitExpression.of((BooleanExpression)situation.getExpression());
        BooleanExpression expression = (BooleanExpression)split.get((Object)row);
        if (expression == null) {
            return "";
        }
        String label = new MsExpressionUnparser(MsExpressionUnparser.Mode.NAME).unparse(expression);
        return LinkedTextDocument.load((LinkedTextDocument.Input)new CapellaEmbeddedLinkedTextEditorInput.Readonly((EObject)row, label)).get();
    }

    public Collection<Situation> msAllSituations(EObject context) {
        ArrayList<Situation> result = new ArrayList<Situation>();
        ComponentArchitecture architecture = (ComponentArchitecture)EcoreUtil2.getFirstContainer((EObject)context, (EClass)CsPackage.Literals.COMPONENT_ARCHITECTURE);
        EObject rootPkg = null;
        if (architecture != null) {
            for (EObject e : architecture.eContents()) {
                if (!(e instanceof ComponentPkg)) continue;
                rootPkg = e;
                break;
            }
        }
        if (rootPkg != null) {
            TreeIterator it = rootPkg.eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (!(next instanceof Situation)) continue;
                result.add((Situation)next);
            }
        }
        return result;
    }

    public Collection<EObject> msSituationExpressionComponentLines(LogicalComponent c) {
        return c.getOwnedLogicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, HAS_STATEMACHINE)).collect(Collectors.toList());
    }

    public Collection<EObject> msSituationExpressionComponentLines(LogicalComponentPkg p) {
        return p.getOwnedLogicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, HAS_STATEMACHINE)).collect(Collectors.toList());
    }

    public Collection<EObject> msSituationExpressionComponentLines(PhysicalComponent c) {
        return this.msComponentLines(c, HAS_STATEMACHINE);
    }

    public Collection<EObject> msCrossTableComponentLines(PhysicalComponent c) {
        return this.msComponentLines(c, (Predicate<Component>)Predicates.alwaysTrue());
    }

    public Collection<EObject> msSituationExpressionComponentLines(PhysicalComponentPkg p) {
        return p.getOwnedPhysicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, HAS_STATEMACHINE)).collect(Collectors.toList());
    }

    public Collection<EObject> msCrossTableComponentPkgLines(EObject target) {
        return this.msComponentPkgLines(target, (Predicate<Component>)Predicates.alwaysTrue());
    }

    public Collection<EObject> msSituationExpressionComponentPkgLines(EObject target) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        block0: for (EObject e : target.eContents()) {
            if (!(e instanceof ComponentPkg)) continue;
            TreeIterator deeper = e.eAllContents();
            while (deeper.hasNext()) {
                if (!(deeper.next() instanceof StateMachine)) continue;
                result.add(e);
                continue block0;
            }
        }
        return result;
    }

    public Collection<EObject> msComponentLines(PhysicalComponent c, Predicate<Component> predicate) {
        Stream<PhysicalComponent> candidateChildren = Stream.concat(c.getDeployedPhysicalComponents().stream(), c.getOwnedPhysicalComponents().stream().filter(child -> child.getDeployingPhysicalComponents().isEmpty()));
        return candidateChildren.filter(child -> this.componentHierarchyWithPredicate((EObject)child, predicate)).collect(Collectors.toList());
    }

    public Collection<EObject> msComponentPkgLines(EObject target, Predicate<Component> predicate) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject e : target.eContents()) {
            if (!(e instanceof ComponentPkg) || !this.componentHierarchyWithPredicate(e, predicate)) continue;
            result.add(e);
        }
        return result;
    }

    public boolean componentHierarchyWithPredicate(EObject e, Predicate<Component> predicate) {
        if (e instanceof Component && predicate.test((Component)e)) {
            return true;
        }
        if (e instanceof LogicalComponentPkg) {
            return Stream.concat(((LogicalComponentPkg)e).getOwnedLogicalComponents().stream(), ((LogicalComponentPkg)e).getOwnedLogicalComponentPkgs().stream()).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        if (e instanceof LogicalComponent) {
            return Stream.concat(((LogicalComponent)e).getOwnedLogicalComponents().stream(), ((LogicalComponent)e).getOwnedLogicalComponentPkgs().stream()).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        if (e instanceof PhysicalComponent) {
            return Stream.concat(Stream.concat(((PhysicalComponent)e).getDeployedPhysicalComponents().stream(), ((PhysicalComponent)e).getOwnedPhysicalComponentPkgs().stream()), ((PhysicalComponent)e).getOwnedPhysicalComponents().stream().filter(p -> p.getDeployingPhysicalComponents().isEmpty())).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        if (e instanceof PhysicalComponentPkg) {
            return Stream.concat(((PhysicalComponentPkg)e).getOwnedPhysicalComponents().stream().filter(p -> p.getDeployingPhysicalComponents().isEmpty()), ((PhysicalComponentPkg)e).getOwnedPhysicalComponentPkgs().stream()).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        return false;
    }

    public Collection<? extends EObject> msSituationExpressionStateMachineLines(EObject container) {
        if (container instanceof Component) {
            return ((Component)container).getOwnedStateMachines();
        }
        if (container instanceof ComponentPkg) {
            return ((ComponentPkg)container).getOwnedStateMachines();
        }
        return Collections.emptyList();
    }

    public Collection<Situation> msSituationExpressionColumns(Component container) {
        ArrayList<Situation> result = new ArrayList<Situation>();
        TreeIterator it = container.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof Situation)) continue;
            try {
                LinkedText2Situation.SplitExpression.of((BooleanExpression)((Situation)next).getExpression());
                result.add((Situation)next);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }
}

