/*
 * Decompiled with CFR 0.152.
 */
package ms.design;

import java.util.ArrayDeque;
import java.util.Collection;
import ms.design.AbstractDNodeScope;
import ms.design.ConfigurationScopeVisitor;
import ms.design.DefaultMsRefreshExtension;
import ms.design.DiagramScope;
import ms.design.Scope;
import ms.design.ScopeFactory;
import ms.design.ScopeVisitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.vp.ms.ui.css.CSSAdapter;

public class InterfaceDiagramMsRefreshExtension
extends DefaultMsRefreshExtension {
    @Override
    public void postRefresh(DDiagram dDiagram) {
        this.refreshNodes(dDiagram);
    }

    @Override
    protected ScopeVisitor<?> createVisitor() {
        return new ConfigurationScopeVisitor(){

            @Override
            protected void updateStyle(AbstractDNodeScope asd) {
                AbstractDNode node = (AbstractDNode)asd.getElement();
                if (node.getTarget() instanceof Interface) {
                    CSSAdapter interfaceStyle = CSSAdapter.getAdapter((EObject)node);
                    for (DEdge edge : ((EdgeTarget)node).getIncomingEdges()) {
                        CSSAdapter portStyle = CSSAdapter.getAdapter((EObject)edge.getSourceNode());
                        CSSAdapter edgeStyle = CSSAdapter.getAdapter((EObject)edge);
                        interfaceStyle.addCSSClass(portStyle);
                        edgeStyle.addCSSClass(portStyle);
                    }
                } else {
                    super.updateStyle(asd);
                }
            }
        };
    }

    @Override
    protected ScopeFactory createScopeFactory() {
        return new ScopeFactory(){

            @Override
            public Scope caseDSemanticDiagram(DSemanticDiagram diagram) {
                return new DiagramScope(diagram){

                    @Override
                    Collection<DDiagramElement> getChildren() {
                        ArrayDeque<DDiagramElement> result = new ArrayDeque<DDiagramElement>();
                        for (DDiagramElement elem : ((DSemanticDiagram)this.getElement()).getOwnedDiagramElements()) {
                            if (elem.getTarget() instanceof Component) {
                                result.addLast(elem);
                                continue;
                            }
                            if (!(elem.getTarget() instanceof Interface)) continue;
                            result.addFirst(elem);
                        }
                        return result;
                    }
                };
            }
        };
    }
}

