/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.expression.parser;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.vp.ms.AndOperation;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.InSituationExpression;
import org.polarsys.capella.vp.ms.InStateExpression;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.NotOperation;
import org.polarsys.capella.vp.ms.OrOperation;
import org.polarsys.capella.vp.ms.util.MsSwitch;

public class MsExpressionUnparser
extends MsSwitch<String> {
    private BooleanExpression root;
    private Mode mode;
    private StateMachine defaultStateMachine;

    public MsExpressionUnparser(Mode mode) {
        this.mode = mode;
    }

    public void setDefaultStatemachine(StateMachine sm) {
        this.defaultStateMachine = sm;
    }

    public String unparse(BooleanExpression expression) {
        this.root = expression;
        return (String)this.doSwitch((EObject)expression);
    }

    private String getHref(EObject e) {
        return "<a href=\"" + EcoreUtil.getID((EObject)e) + "\"/>";
    }

    public String caseInStateExpression(InStateExpression object) {
        switch (this.mode) {
            case HYPERLINK: {
                return this.getHref((EObject)object.getState());
            }
            case NAME: {
                return object.getState().getName();
            }
            case QNAME: {
                AbstractState s = object.getState();
                StateMachine sm = (StateMachine)EcoreUtil2.getFirstContainer((EObject)s, (EClass)CapellacommonPackage.Literals.STATE_MACHINE);
                if (sm == this.defaultStateMachine) {
                    return s.getName();
                }
                return String.format("%s.%s", sm.getName(), s.getName());
            }
        }
        return null;
    }

    public String caseInSituationExpression(InSituationExpression object) {
        throw new UnsupportedOperationException();
    }

    public String caseAndOperation(AndOperation object) {
        ArrayList<String> childText = new ArrayList<String>();
        for (BooleanExpression child : object.getChildren()) {
            childText.add((String)this.doSwitch((EObject)child));
        }
        String result = String.join((CharSequence)" AND ", childText);
        if (object != this.root && object.eContainer().eClass() == MsPackage.Literals.NOT_OPERATION) {
            result = "(" + result + ")";
        }
        return result;
    }

    public String caseOrOperation(OrOperation object) {
        ArrayList<String> childText = new ArrayList<String>();
        for (BooleanExpression child : object.getChildren()) {
            childText.add((String)this.doSwitch((EObject)child));
        }
        String result = String.join((CharSequence)" OR ", childText);
        if (object != this.root && (object.eContainer().eClass() == MsPackage.Literals.AND_OPERATION || object.eContainer().eClass() == MsPackage.Literals.NOT_OPERATION)) {
            result = "(" + result + ")";
        }
        return result;
    }

    public String caseNotOperation(NotOperation object) {
        String result = "NOT " + (String)this.doSwitch((EObject)object.getChildren().get(0));
        if (object != this.root && object.eContainer().eClass() == MsPackage.Literals.NOT_OPERATION) {
            result = "(" + result + ")";
        }
        return result;
    }

    public static enum Mode {
        HYPERLINK,
        NAME,
        QNAME;

    }
}

