/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.statemachine.validation;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.tools.report.util.ReportManagerDefaultComponents;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.common.statemachine.validation.CartesianProduct;
import org.polarsys.capella.core.data.common.statemachine.validation.GeneralMode;
import org.polarsys.capella.core.data.common.statemachine.validation.StateMachineUtils;

public class MDCHK_ModeMachineRegions_Configurations
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof StateMachine) {
            StateMachine stateMachine = (StateMachine)ctx.getTarget();
            if (!stateMachine.getOwnedRegions().isEmpty()) {
                BasicEList modesOfRegions = new BasicEList();
                for (Region region : stateMachine.getOwnedRegions()) {
                    BasicEList modesOfRegion = new BasicEList();
                    modesOfRegion.addAll(StateMachineUtils.getAllModes(region));
                    modesOfRegions.add((Object)modesOfRegion);
                }
                CartesianProduct cartesianProduct = new CartesianProduct(modesOfRegions);
                BasicEList generalModes = new BasicEList();
                EList cartesianProductResult = cartesianProduct.compute();
                for (EList modes : cartesianProductResult) {
                    GeneralMode generalMode = new GeneralMode();
                    generalMode.getModes().addAll((Collection)modes);
                    generalMode.getConfigurations().addAll(StateMachineUtils.getCommonConfigurations((EList<Mode>)modes));
                    generalModes.add((Object)generalMode);
                }
                this.display((EList<GeneralMode>)generalModes);
            }
            return ctx.createSuccessStatus();
        }
        return null;
    }

    public void display(EList<GeneralMode> generalModes) {
        Logger modelLogger = ReportManagerDefaultComponents.getReportManagerForModel();
        int i = 0;
        while (i < generalModes.size()) {
            GeneralMode generalMode = (GeneralMode)generalModes.get(i);
            modelLogger.info((Object)("'Global Mode" + i + "' composed of:" + generalMode.getName()));
            modelLogger.info((Object)" the configurations available for this Global Mode: ");
            modelLogger.info((Object)generalMode.getConfigurationsName());
            ++i;
        }
    }
}

