/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.expression.parser;

import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.vp.ms.AndOperation;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.InSituationExpression;
import org.polarsys.capella.vp.ms.InStateExpression;
import org.polarsys.capella.vp.ms.MsFactory;
import org.polarsys.capella.vp.ms.NotOperation;
import org.polarsys.capella.vp.ms.OrOperation;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionBaseVisitor;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionParser;

public class DefaultMsExpressionVisitor
extends MsExpressionBaseVisitor<BooleanExpression> {
    private final Function<String, EObject> resolver;

    public DefaultMsExpressionVisitor(Function<String, EObject> resolver) {
        this.resolver = resolver;
    }

    @Override
    public BooleanExpression visitNotExpr(MsExpressionParser.NotExprContext ctx) {
        BooleanExpression result = null;
        if (ctx.orExpr() != null) {
            result = this.visitOrExpr(ctx.orExpr());
        } else if (ctx.href() != null) {
            result = this.visitHref(ctx.href());
        }
        if (ctx.NEG() != null) {
            BooleanExpression child = result;
            result = MsFactory.eINSTANCE.createNotOperation();
            ((NotOperation)result).getChildren().add((Object)child);
        }
        return result;
    }

    @Override
    public BooleanExpression visitOrExpr(MsExpressionParser.OrExprContext ctx) {
        if (ctx.andExpr().size() > 1) {
            OrOperation result = MsFactory.eINSTANCE.createOrOperation();
            for (MsExpressionParser.AndExprContext and : ctx.andExpr()) {
                result.getChildren().add((Object)((BooleanExpression)this.visit((ParseTree)and)));
            }
            return result;
        }
        return (BooleanExpression)this.visit((ParseTree)ctx.andExpr(0));
    }

    @Override
    public BooleanExpression visitHref(MsExpressionParser.HrefContext ctx) {
        EObject target = this.resolver.apply(ctx.ID().getText());
        InStateExpression result = null;
        if (target instanceof AbstractState) {
            result = MsFactory.eINSTANCE.createInStateExpression();
            result.setState((AbstractState)target);
        } else if (target instanceof Situation) {
            result = MsFactory.eINSTANCE.createInSituationExpression();
            ((InSituationExpression)result).setSituation((Situation)target);
        }
        return result;
    }

    @Override
    public BooleanExpression visitAndExpr(MsExpressionParser.AndExprContext ctx) {
        if (ctx.notExpr().size() > 1) {
            AndOperation result = MsFactory.eINSTANCE.createAndOperation();
            for (MsExpressionParser.NotExprContext not : ctx.notExpr()) {
                result.getChildren().add((Object)((BooleanExpression)this.visit((ParseTree)not)));
            }
            return result;
        }
        return (BooleanExpression)this.visit((ParseTree)ctx.notExpr(0));
    }
}

