/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.ClasspathUriResolutionException;
import org.eclipse.xtext.resource.ClasspathUriUtil;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.osgi.framework.Bundle;

public class BundleClasspathUriResolver
implements IClasspathUriResolver {
    public URI resolve(Object context, URI classpathUri) {
        if (context instanceof Plugin) {
            context = ((Plugin)context).getBundle();
        }
        if (!(context instanceof Bundle)) {
            throw new IllegalArgumentException("Context must implement Bundle");
        }
        Bundle bundle = (Bundle)context;
        try {
            if (ClasspathUriUtil.isClasspathUri((URI)classpathUri)) {
                URI result = this.findResourceInBundle(bundle, classpathUri);
                if (classpathUri.fragment() != null) {
                    result = result.appendFragment(classpathUri.fragment());
                }
                return result;
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    private URI findResourceInBundle(Bundle bundle, URI classpathUri) throws MalformedURLException, IOException {
        String projectRelativePath;
        URL resourceUrl;
        Path fullPath = new Path(classpathUri.path());
        if (bundle != null && (resourceUrl = bundle.getResource(projectRelativePath = "/" + fullPath)) != null) {
            URL resolvedUrl = FileLocator.resolve((URL)resourceUrl);
            URI normalizedURI = URI.createURI((String)resolvedUrl.toString(), (boolean)true);
            return normalizedURI;
        }
        return classpathUri;
    }
}

