/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.helpers.interaction.services.AbstractEndExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RoleAllocation;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class DataFlowHelper {
    public static List<FunctionalExchange> getAvailableFonctionalExchanges(SequenceMessage message) {
        InstanceRole sourceInstanceRole = AbstractEndExt.getInstanceRole((AbstractEnd)message.getSendingEnd());
        InstanceRole targetInstanceRole = AbstractEndExt.getInstanceRole((AbstractEnd)message.getReceivingEnd());
        return DataFlowHelper.getAvailableFonctionalExchanges(sourceInstanceRole, targetInstanceRole);
    }

    public static List<FunctionalExchange> getAvailableFonctionalExchanges(InstanceRole sourceIR, InstanceRole targetIR) {
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        ArrayList<FunctionalExchange> resultExchangeSender = new ArrayList<FunctionalExchange>();
        ArrayList<FunctionalExchange> resultExchangeReceiver = new ArrayList<FunctionalExchange>();
        if (targetIR != null) {
            List<AbstractFunction> resultReceiver = DataFlowHelper.findFunctionRealizedByInstanceRole(targetIR);
            for (AbstractFunction function : resultReceiver) {
                resultExchangeReceiver.addAll(DataFlowHelper.getExchangeDestinationByFunction(function));
            }
        }
        if (sourceIR != null) {
            List<AbstractFunction> resultSender = DataFlowHelper.findFunctionRealizedByInstanceRole(sourceIR);
            for (AbstractFunction function : resultSender) {
                resultExchangeSender.addAll(DataFlowHelper.getExchangeSourceByFunction(function));
            }
        }
        if (sourceIR == null) {
            result.addAll(resultExchangeReceiver);
        } else if (targetIR == null) {
            result.addAll(resultExchangeSender);
        } else {
            for (FunctionalExchange functionalExchange : resultExchangeSender) {
                if (!resultExchangeReceiver.contains(functionalExchange)) continue;
                result.add(functionalExchange);
            }
        }
        return result;
    }

    public static List<FunctionalExchange> getAvailableFonctionalExchanges(AbstractInstance sourceInstance, AbstractInstance targetInstance) {
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        ArrayList<FunctionalExchange> resultExchangeSender = new ArrayList<FunctionalExchange>();
        ArrayList<FunctionalExchange> resultExchangeReceiver = new ArrayList<FunctionalExchange>();
        if (targetInstance != null) {
            List<AbstractFunction> resultReceiver = DataFlowHelper.findFunctionRealizedByAbstractInstance(targetInstance);
            for (AbstractFunction function : resultReceiver) {
                resultExchangeReceiver.addAll(DataFlowHelper.getExchangeDestinationByFunction(function));
            }
        }
        if (sourceInstance != null) {
            List<AbstractFunction> resultSender = DataFlowHelper.findFunctionRealizedByAbstractInstance(sourceInstance);
            for (AbstractFunction function : resultSender) {
                resultExchangeSender.addAll(DataFlowHelper.getExchangeSourceByFunction(function));
            }
        }
        if (sourceInstance == null) {
            result.addAll(resultExchangeReceiver);
        } else if (targetInstance == null) {
            result.addAll(resultExchangeSender);
        } else {
            for (FunctionalExchange functionalExchange : resultExchangeSender) {
                if (!resultExchangeReceiver.contains(functionalExchange)) continue;
                result.add(functionalExchange);
            }
        }
        return result;
    }

    private static List<FunctionalExchange> getExchangeDestinationByFunction(AbstractFunction function) {
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        for (InputPin inputPin : function.getInputs()) {
            for (Iterator ae : inputPin.getIncoming()) {
                if (!(ae instanceof FunctionalExchange)) continue;
                FunctionalExchange fe = (FunctionalExchange)ae;
                result.add(fe);
            }
        }
        if (function instanceof OperationalActivity) {
            OperationalActivity oa = (OperationalActivity)function;
            for (ActivityEdge ae : oa.getIncoming()) {
                if (!(ae instanceof FunctionalExchange)) continue;
                FunctionalExchange fe = (FunctionalExchange)ae;
                result.add(fe);
            }
        }
        for (EObject obj : function.eContents()) {
            if (!(obj instanceof AbstractFunction)) continue;
            AbstractFunction subFunction = (AbstractFunction)obj;
            result.addAll(DataFlowHelper.getExchangeDestinationByFunction(subFunction));
        }
        return result;
    }

    private static List<FunctionalExchange> getExchangeSourceByFunction(AbstractFunction function) {
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        for (OutputPin output : function.getOutputs()) {
            for (Iterator ae : output.getOutgoing()) {
                if (!(ae instanceof FunctionalExchange)) continue;
                FunctionalExchange fe = (FunctionalExchange)ae;
                result.add(fe);
            }
        }
        if (function instanceof OperationalActivity) {
            OperationalActivity oa = (OperationalActivity)function;
            for (ActivityEdge ae : oa.getOutgoing()) {
                if (!(ae instanceof FunctionalExchange)) continue;
                FunctionalExchange fe = (FunctionalExchange)ae;
                result.add(fe);
            }
        }
        for (EObject obj : function.eContents()) {
            if (!(obj instanceof AbstractFunction)) continue;
            AbstractFunction subFunction = (AbstractFunction)obj;
            result.addAll(DataFlowHelper.getExchangeSourceByFunction(subFunction));
        }
        return result;
    }

    public static List<AbstractFunction> findFunctionRealizedByInstanceRole(InstanceRole instanceRole) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        if (instanceRole != null) {
            AbstractInstance ai = instanceRole.getRepresentedInstance();
            return DataFlowHelper.findFunctionRealizedByAbstractInstance(ai);
        }
        return result;
    }

    public static List<AbstractFunction> findFunctionRealizedByAbstractInstance(AbstractInstance ai) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        if (ai != null) {
            AbstractType at = ai.getAbstractType();
            if (ai instanceof Role) {
                Role role = (Role)ai;
                for (ActivityAllocation aa : role.getOwnedActivityAllocations()) {
                    if (aa == null) continue;
                    result.add((AbstractFunction)aa.getActivity());
                }
            }
            if (at instanceof Component) {
                Component component = (Component)at;
                for (AbstractFunctionAllocation f : component.getOwnedFunctionalAllocation()) {
                    AbstractFunction function = (AbstractFunction)f.getTargetElement();
                    if (function == null) continue;
                    result.add(function);
                }
                for (Component subComponent : ComponentExt.getAllSubUsedAndDeployedComponents((Component)component)) {
                    for (AbstractFunctionAllocation f : subComponent.getOwnedFunctionalAllocation()) {
                        AbstractFunction function = (AbstractFunction)f.getTargetElement();
                        if (function == null) continue;
                        result.add(function);
                    }
                }
                if (component instanceof Entity) {
                    Entity entity = (Entity)component;
                    for (RoleAllocation roleAlloc : entity.getOwnedRoleAllocations()) {
                        Role role = roleAlloc.getRole();
                        for (ActivityAllocation f : role.getActivityAllocations()) {
                            AbstractFunction function = (AbstractFunction)f.getTargetElement();
                            if (function == null) continue;
                            result.add(function);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static boolean isFeDiagram(Scenario scenario) {
        boolean foundCe = false;
        for (Event event : scenario.getOwnedEvents()) {
            EventSentOperation eso;
            if (!(event instanceof EventSentOperation) || !((eso = (EventSentOperation)event).getOperation() instanceof ComponentExchange)) continue;
            foundCe = true;
        }
        return !foundCe;
    }

    public static boolean isCeDiagram(Scenario scenario) {
        boolean foundFe = false;
        for (Event event : scenario.getOwnedEvents()) {
            EventSentOperation eso;
            if (!(event instanceof EventSentOperation) || !((eso = (EventSentOperation)event).getOperation() instanceof FunctionalExchange)) continue;
            foundFe = true;
        }
        return !foundFe;
    }

    public static Collection<? extends AbstractEventOperation> getAvailableComponentExchanges(SequenceMessage message) {
        InstanceRole sourceInstanceRole = AbstractEndExt.getInstanceRole((AbstractEnd)message.getSendingEnd());
        InstanceRole targetInstanceRole = AbstractEndExt.getInstanceRole((AbstractEnd)message.getReceivingEnd());
        return DataFlowHelper.getAvailableComponentExchanges(sourceInstanceRole, targetInstanceRole);
    }

    private static List<Component> getAllComponentHierarchy(Component component) {
        PhysicalComponent pc;
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(component);
        for (Generalization generalization : component.getOwnedGeneralizations()) {
            GeneralizableElement super_ = generalization.getSuper();
            if (!(super_ instanceof Component)) continue;
            result.addAll(DataFlowHelper.getAllComponentHierarchy((Component)super_));
        }
        if (component instanceof PhysicalComponent && (pc = (PhysicalComponent)component).getNature().equals((Object)PhysicalComponentNature.NODE)) {
            for (PhysicalComponent deployedPC : pc.getDeployedPhysicalComponents()) {
                result.addAll(DataFlowHelper.getAllComponentHierarchy((Component)deployedPC));
            }
            for (Component sub : ComponentExt.getSubDefinedComponents((Component)pc)) {
                result.addAll(DataFlowHelper.getAllComponentHierarchy(sub));
            }
        }
        return result;
    }

    private static List<ComponentExchange> getCEFromComponent(Component component, OrientationPortKind orientation) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        for (Feature f : component.getOwnedFeatures()) {
            ComponentPort port;
            if (!(f instanceof ComponentPort) || !DataFlowHelper.isDirectionCompatible((port = (ComponentPort)f).getOrientation(), orientation)) continue;
            for (ComponentExchange componentExchange : port.getComponentExchanges()) {
                result.add(componentExchange);
                if (!componentExchange.getKind().equals((Object)ComponentExchangeKind.DELEGATION)) continue;
                result.addAll(ComponentExchangeExt.getDelegatedComponentExchanges((ComponentPort)port, (ComponentExchange)componentExchange));
            }
        }
        if (component instanceof Entity) {
            Entity entity = (Entity)component;
            if (orientation == OrientationPortKind.OUT) {
                for (AbstractInformationFlow if_ : entity.getOutgoingInformationFlows()) {
                    if (!(if_ instanceof CommunicationMean)) continue;
                    result.add((ComponentExchange)if_);
                }
            }
            if (orientation == OrientationPortKind.IN) {
                for (AbstractInformationFlow if_ : entity.getIncomingInformationFlows()) {
                    if (!(if_ instanceof CommunicationMean)) continue;
                    result.add((ComponentExchange)if_);
                }
            }
        }
        return result;
    }

    private static boolean isDirectionCompatible(OrientationPortKind portOrientation, OrientationPortKind searchedOrientation) {
        boolean result = false;
        switch (searchedOrientation) {
            case IN: {
                result = portOrientation == OrientationPortKind.IN || portOrientation == OrientationPortKind.INOUT;
                break;
            }
            case OUT: {
                result = portOrientation == OrientationPortKind.OUT || portOrientation == OrientationPortKind.INOUT;
                break;
            }
            case UNSET: 
            case INOUT: {
                result = true;
            }
        }
        return result;
    }

    public static List<FunctionalExchange> getAvailableFonctionalExchangesFromFunctions(SequenceMessage message) {
        InstanceRole sourceInstanceRole = AbstractEndExt.getInstanceRole((AbstractEnd)message.getSendingEnd());
        InstanceRole targetInstanceRole = AbstractEndExt.getInstanceRole((AbstractEnd)message.getReceivingEnd());
        return DataFlowHelper.getAvailableFonctionalExchangesFromFunctions(sourceInstanceRole, targetInstanceRole);
    }

    public static List<FunctionalExchange> getAvailableFonctionalExchangesFromFunctions(InstanceRole sourceIR, InstanceRole targetIR) {
        AbstractFunction resultSender = (AbstractFunction)sourceIR.getRepresentedInstance();
        AbstractFunction resultReceiver = (AbstractFunction)targetIR.getRepresentedInstance();
        return DataFlowHelper.getAvailableFonctionalExchangesFromFunctions(resultSender, resultReceiver);
    }

    public static List<FunctionalExchange> getAvailableFonctionalExchangesFromFunctions(AbstractFunction resultSender, AbstractFunction resultReceiver) {
        ArrayList<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        ArrayList<FunctionalExchange> resultExchangeReceiver = new ArrayList<FunctionalExchange>();
        resultExchangeReceiver.addAll(DataFlowHelper.getExchangeDestinationByFunction(resultReceiver));
        ArrayList<FunctionalExchange> resultExchangeSender = new ArrayList<FunctionalExchange>();
        resultExchangeSender.addAll(DataFlowHelper.getExchangeSourceByFunction(resultSender));
        for (FunctionalExchange functionalExchange : resultExchangeSender) {
            if (!resultExchangeReceiver.contains(functionalExchange)) continue;
            result.add(functionalExchange);
        }
        return result;
    }

    public static Collection<? extends AbstractEventOperation> getAvailableComponentExchanges(InstanceRole sourceIR, InstanceRole targetIR) {
        Component sourceComponent = (Component)(sourceIR == null ? null : sourceIR.getRepresentedInstance().getAbstractType());
        Component targetComponent = (Component)(targetIR == null ? null : targetIR.getRepresentedInstance().getAbstractType());
        return DataFlowHelper.getAvailableComponentExchanges(sourceComponent, targetComponent);
    }

    public static Collection<? extends AbstractEventOperation> getAvailableComponentExchanges(Component sourceComponent, Component targetComponent) {
        ArrayList result = new ArrayList();
        ArrayList<ComponentExchange> sourceConnections = new ArrayList<ComponentExchange>();
        if (sourceComponent != null) {
            for (Component component : DataFlowHelper.getAllComponentHierarchy(sourceComponent)) {
                sourceConnections.addAll(DataFlowHelper.getCEFromComponent(component, OrientationPortKind.OUT));
            }
        }
        ArrayList<ComponentExchange> targetConnections = new ArrayList<ComponentExchange>();
        if (targetComponent != null) {
            for (Component component : DataFlowHelper.getAllComponentHierarchy(targetComponent)) {
                targetConnections.addAll(DataFlowHelper.getCEFromComponent(component, OrientationPortKind.IN));
            }
        }
        if (sourceComponent == null) {
            result.addAll(targetConnections);
        } else if (targetComponent == null) {
            result.addAll(sourceConnections);
        } else {
            for (ComponentExchange connection : targetConnections) {
                if (!sourceConnections.contains(connection)) continue;
                result.add(connection);
            }
        }
        return result;
    }
}

