/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.embeddededitor.views;

import com.google.inject.Injector;
import javax.inject.Inject;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.polarsys.capella.scenario.editor.EmbeddedEditorInstance;
import org.polarsys.capella.scenario.editor.dsl.provider.TextualScenarioProvider;
import org.polarsys.capella.scenario.editor.dsl.ui.internal.DslActivator;
import org.polarsys.capella.scenario.editor.embeddededitor.actions.XtextEditorActionFactory;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.HelperCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.listener.EmbeddedEditorSessionListener;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;

public class EmbeddedEditorView
extends ViewPart {
    private TabbedPropertyTitle scenarioTitle;
    private SessionManagerListener sessionListener;
    public static final String ID = "org.eclipse.xtext.example.domainmodel.embeddededitor.views.EmbeddedEditorView";
    @Inject
    IWorkbench workbench;
    TextualScenarioProvider provider;

    public void createPartControl(Composite parent) {
        this.makeActions();
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.grabExcessVerticalSpace = false;
        this.scenarioTitle = new TabbedPropertyTitle(parent, new TabbedPropertySheetWidgetFactory());
        this.scenarioTitle.setLayoutData((Object)titleLayoutData);
        this.scenarioTitle.setTitle("Textual Editor", null);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent.setLayout((Layout)layout);
        DslActivator activator = DslActivator.getInstance();
        Injector injector = activator.getInjector("org.polarsys.capella.scenario.editor.dsl.TextualScenario");
        EditorsPlugin.getDefault().getPreferenceStore().setValue("spellingEnabled", false);
        this.provider = (TextualScenarioProvider)injector.getInstance(TextualScenarioProvider.class);
        EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
        EmbeddedEditor editor = factory.newEditor((IEditedResourceProvider)this.provider).withParent(parent);
        editor.createPartialEditor();
        EmbeddedEditorInstance.setEmbeddedEditor((EmbeddedEditor)editor);
        this.addSessionListener();
        EmbeddedEditorInstanceHelper.setOpenedRepresentation();
        if (EmbeddedEditorInstance.getDDiagram() != null) {
            HelperCommands.refreshTextEditor(this);
        }
        if (this.getViewSite().getPage() != null) {
            this.getViewSite().getPage().addSelectionListener(EmbeddedEditorSessionListener.getSelectionListener());
        }
    }

    private void addSessionListener() {
        this.sessionListener = new EmbeddedEditorSessionListener();
        SessionManager.INSTANCE.addSessionsListener(this.sessionListener);
    }

    private void removeSessionListener() {
        SessionManager.INSTANCE.removeSessionsListener(this.sessionListener);
        this.sessionListener = null;
    }

    public TextualScenarioProvider getProvider() {
        return this.provider;
    }

    public void refreshTitleBar(String title) {
        if (!this.scenarioTitle.isDisposed()) {
            this.scenarioTitle.setRedraw(false);
            this.scenarioTitle.setTitle(title, null);
            this.scenarioTitle.setRedraw(true);
        }
    }

    private void makeActions() {
        XtextEditorActionFactory actionsFactory = new XtextEditorActionFactory();
        actionsFactory.createRefreshAction(this);
        actionsFactory.createSaveAction(this);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.removeSessionListener();
        if (this.getViewSite().getPage() != null) {
            this.getViewSite().getPage().removeSelectionListener(EmbeddedEditorSessionListener.getSelectionListener());
        }
        super.dispose();
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return EmbeddedEditorView.this.workbench.getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

