/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.shared;

import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtext.ui.shared.internal.Activator;
import org.eclipse.xtext.ui.util.IJdtHelper;

@Singleton
public class JdtHelper
implements IJdtHelper {
    private static final Logger log = Logger.getLogger(JdtHelper.class);
    private final boolean javaCoreAvailable = this.computeJavaCoreAvailable();

    protected boolean computeJavaCoreAvailable() {
        return Activator.isJavaEnabled();
    }

    public boolean isJavaCoreAvailable() {
        return this.javaCoreAvailable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFromOutputPath(IResource resource) {
        IProject project = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) return false;
        if (!javaProject.exists()) return false;
        try {
            IClasspathEntry[] classpathEntries;
            IPath defaultOutputLocation = javaProject.getOutputLocation();
            IPath resourcePath = resource.getFullPath();
            if (defaultOutputLocation != null && !defaultOutputLocation.isEmpty() && defaultOutputLocation.isPrefixOf(resourcePath)) {
                return true;
            }
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getRawClasspath();
            int n = classpathEntries.length;
            int n2 = 0;
            while (true) {
                IPath specializedOutputLocation;
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3 && (specializedOutputLocation = classpathEntry.getOutputLocation()) != null && !specializedOutputLocation.equals((Object)classpathEntry.getPath()) && specializedOutputLocation.isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug((Object)("Error in isJavaTargetFolder():" + e.getMessage()), (Throwable)e);
        }
        return false;
    }
}

