/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.ui.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.xbase.validation.UniqueClassNameValidator;

public class ProjectAwareUniqueClassNameValidator
extends UniqueClassNameValidator {
    private static final Logger LOG = Logger.getLogger(ProjectAwareUniqueClassNameValidator.class);
    private static final String OUTPUT_CONFIGS = "ProjectAwareUniqueClassNameValidator.outputConfigs";
    @Inject
    private IJavaProjectProvider javaProjectProvider;
    @Inject
    private IDerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private IContextualOutputConfigurationProvider outputConfigurationProvider;

    public boolean doCheckUniqueName(QualifiedName name, JvmDeclaredType type) {
        if (!super.doCheckUniqueName(name, type)) {
            return false;
        }
        try {
            return this.doCheckUniqueInProject(name, type);
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return true;
        }
    }

    private SourceTraversal doCheckUniqueInProjectSource(String packageName, String typeName, JvmDeclaredType type, List<IPackageFragmentRoot> sourceFolders) throws JavaModelException {
        IndexManager indexManager = JavaModelManager.getIndexManager();
        for (IPackageFragmentRoot sourceFolder : sourceFolders) {
            if (indexManager.awaitingJobsCount() > 0) {
                IPackageFragment packageFragment;
                if (this.isDerived(sourceFolder.getResource()) || !(packageFragment = sourceFolder.getPackageFragment(packageName)).exists()) continue;
                ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                int n = iCompilationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType javaType;
                    ICompilationUnit unit = iCompilationUnitArray[n2];
                    if (!this.isDerived(unit.getResource()) && (javaType = unit.getType(typeName)).exists()) {
                        this.addIssue(type, unit.getElementName());
                        return SourceTraversal.DUPLICATE;
                    }
                    ++n2;
                }
                continue;
            }
            return SourceTraversal.INTERRUPT;
        }
        return SourceTraversal.UNIQUE;
    }

    public boolean doCheckUniqueInProject(QualifiedName name, final JvmDeclaredType type) throws JavaModelException {
        IJavaProject javaProject = this.javaProjectProvider.getJavaProject(type.eResource().getResourceSet());
        this.getContext().put(OUTPUT_CONFIGS, this.outputConfigurationProvider.getOutputConfigurations(type.eResource()));
        String packageName = type.getPackageName();
        String typeName = type.getSimpleName();
        IndexManager indexManager = JavaModelManager.getIndexManager();
        ArrayList<IPackageFragmentRoot> sourceFolders = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                sourceFolders.add(root);
            }
            ++n2;
        }
        if (sourceFolders.isEmpty() || indexManager.awaitingJobsCount() > 0) {
            SourceTraversal sourceTraversal = this.doCheckUniqueInProjectSource(packageName != null ? packageName : "", typeName, type, sourceFolders);
            if (sourceTraversal == SourceTraversal.DUPLICATE) {
                return false;
            }
            if (sourceTraversal == SourceTraversal.UNIQUE) {
                return true;
            }
        }
        final HashSet<String> workingCopyPaths = new HashSet<String>();
        ICompilationUnit[] copies = this.getWorkingCopies(type);
        if (copies != null) {
            ICompilationUnit[] iCompilationUnitArray = copies;
            int n3 = copies.length;
            int n4 = 0;
            while (n4 < n3) {
                ICompilationUnit workingCopy = iCompilationUnitArray[n4];
                IPath path = workingCopy.getPath();
                if (javaProject.getPath().isPrefixOf(path) && !this.isDerived(workingCopy.getResource())) {
                    IType result;
                    if (workingCopy.getPackageDeclaration(packageName).exists() && (result = workingCopy.getType(typeName)).exists()) {
                        this.addIssue(type, workingCopy.getElementName());
                        return false;
                    }
                    workingCopyPaths.add(workingCopy.getPath().toString());
                }
                ++n4;
            }
        }
        char[] pkg = packageName == null ? CharOperation.NO_CHAR : packageName.toCharArray();
        TypeDeclarationPattern pattern = new TypeDeclarationPattern(pkg, CharOperation.NO_CHAR_CHAR, typeName.toCharArray(), '\u0000', 8);
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                if (workingCopyPaths.contains(documentPath)) {
                    return true;
                }
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(documentPath));
                if (!ProjectAwareUniqueClassNameValidator.this.isDerived((IResource)file)) {
                    ProjectAwareUniqueClassNameValidator.this.addIssue(type, file.getName());
                    return false;
                }
                return true;
            }
        };
        try {
            SearchParticipant searchParticipant = BasicSearchEngine.getDefaultSearchParticipant();
            IJavaSearchScope javaSearchScope = BasicSearchEngine.createJavaSearchScope((IJavaElement[])sourceFolders.toArray(new IJavaElement[0]));
            PatternSearchJob patternSearchJob = new PatternSearchJob((SearchPattern)pattern, searchParticipant, javaSearchScope, searchRequestor);
            indexManager.performConcurrentJob((IJob)patternSearchJob, 3, null);
            return true;
        }
        catch (Throwable OperationCanceledException2) {
            return false;
        }
    }

    private ICompilationUnit[] getWorkingCopies(JvmDeclaredType type) {
        return ResourceSetContext.get((Notifier)type).isBuilder() ? new ICompilationUnit[]{} : JavaModelManager.getJavaModelManager().getWorkingCopies((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, false);
    }

    protected boolean isDerived(IResource resource) {
        try {
            if (this.derivedResourceMarkers != null && this.derivedResourceMarkers.findDerivedResourceMarkers(resource).length >= 1) {
                return true;
            }
        }
        catch (CoreException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        Collection outputConfigurations = (Collection)this.getContext().get(OUTPUT_CONFIGS);
        if (outputConfigurations != null) {
            IPath projectRelativePath = resource.getProjectRelativePath();
            for (OutputConfiguration outputConfiguration : outputConfigurations) {
                for (String dir : outputConfiguration.getOutputDirectories()) {
                    for (OutputConfiguration.SourceMapping sourceMapping : outputConfiguration.getSourceMappings()) {
                        String sourceFolder;
                        if (!sourceMapping.getSourceFolder().endsWith(dir) || !new Path(sourceFolder = sourceMapping.getSourceFolder()).isPrefixOf(projectRelativePath)) continue;
                        return true;
                    }
                    if (!new Path(dir).isPrefixOf(projectRelativePath)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean checkUniqueInIndex(JvmDeclaredType type, Iterable<IEObjectDescription> descriptions) {
        URI typeUri = EcoreUtil.getURI((EObject)type);
        if (typeUri.isPlatformResource()) {
            String projectName = typeUri.segment(1);
            return super.checkUniqueInIndex(type, Iterables.filter(descriptions, description -> {
                URI descriptionUri = description.getEObjectURI();
                return descriptionUri.isPlatformResource() && projectName.equals(descriptionUri.segment(1));
            }));
        }
        return true;
    }

    private static enum SourceTraversal {
        INTERRUPT,
        DUPLICATE,
        UNIQUE;

    }
}

