/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases.rules;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.EClassSelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.transition.system2subsystem.crossphases.rules.pa.PhysicalComponentRule;
import org.polarsys.capella.transition.system2subsystem.multiphases.MultiphasesContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class PhysicalComponentRules {

    public static class ToLA
    extends PhysicalComponentRule {
        protected EObject getBestContainer(EObject element, EObject result, IContext context) {
            if (!ContextScopeHandlerHelper.getInstance((IContext)context).contains("SOURCE_SCOPE", element, context)) {
                return null;
            }
            if (element instanceof PhysicalComponent && ((PhysicalComponent)element).getDeployingPhysicalComponents().isEmpty()) {
                EObject sourceContainer = element.eContainer();
                EClassSelectionContext sContext = new EClassSelectionContext(SelectionContextHandlerHelper.getHandler((IContext)context).getSelectionContext(context, "SC__T", element, result), LaPackage.Literals.LOGICAL_COMPONENT);
                return TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(sourceContainer, context, (ISelectionContext)sContext);
            }
            MultiphasesContext multiphasesContext = (MultiphasesContext)context;
            SystemEngineering eng = multiphasesContext.getTempSystemEngineering();
            LogicalArchitecture la = (LogicalArchitecture)eng.getContainedLogicalArchitectures().get(0);
            return BlockArchitectureExt.getOrCreateSystem((BlockArchitecture)la);
        }

        protected EObject transformDirectElement(EObject element_p, IContext context_p) {
            PhysicalComponent element = (PhysicalComponent)element_p;
            MultiphasesContext context = (MultiphasesContext)context_p;
            if (element.getNature() == PhysicalComponentNature.NODE) {
                PhysicalComponent tmp = element;
                while (tmp instanceof PhysicalComponent) {
                    if (context.getSelectedPhysicalComponents().contains(tmp)) {
                        return context.getTempRootComponent();
                    }
                    tmp = tmp.eContainer();
                }
            }
            EObject result = EcoreUtil.create((EClass)this.getTargetType(element_p, context_p));
            if (element_p instanceof AbstractNamedElement && result instanceof AbstractNamedElement) {
                ((AbstractNamedElement)result).setName(((AbstractNamedElement)element_p).getName());
            }
            return result;
        }

        public EClass getTargetType(EObject element, IContext context) {
            return LaPackage.Literals.LOGICAL_COMPONENT;
        }

        public IStatus transformRequired(EObject source_p, IContext context_p) {
            if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", source_p, context_p)) {
                return Status.OK_STATUS;
            }
            IStatus result = super.transformRequired(source_p, context_p);
            return result;
        }
    }

    public static class ToPA
    extends PhysicalComponentRule {
        protected EObject getBestContainer(EObject element, EObject result, IContext context) {
            if (!ContextScopeHandlerHelper.getInstance((IContext)context).contains("SOURCE_SCOPE", element, context)) {
                return null;
            }
            EObject bestContainer = null;
            EObject container = this.getSourceContainer(element, result, context);
            EClassSelectionContext sContext = new EClassSelectionContext(SelectionContextHandlerHelper.getHandler((IContext)context).getSelectionContext(context, "SC__T", element, result), PaPackage.Literals.PHYSICAL_COMPONENT);
            if (container != null) {
                bestContainer = TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(container, context, (ISelectionContext)sContext);
            }
            if (bestContainer == null) {
                Component component = (Component)element;
                EObject root = TransformationHandlerHelper.getInstance((IContext)context).getLevelElement(element, context);
                BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(root, context, CsPackage.Literals.BLOCK_ARCHITECTURE, element, result);
                Component componentT = (Component)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement((EObject)component, context, (ISelectionContext)sContext);
                if (!ComponentExt.isActor((Component)componentT) && BlockArchitectureExt.getFirstComponent((BlockArchitecture)target, (boolean)false) != null) {
                    bestContainer = BlockArchitectureExt.getFirstComponent((BlockArchitecture)target, (boolean)false);
                }
            }
            return bestContainer;
        }

        public EClass getTargetType(EObject element, IContext context) {
            return PaPackage.Literals.PHYSICAL_COMPONENT;
        }

        public IStatus transformRequired(EObject source_p, IContext context_p) {
            IStatus result = super.transformRequired(source_p, context_p);
            if (source_p instanceof PhysicalComponent && ((PhysicalComponent)source_p).getNature() == PhysicalComponentNature.BEHAVIOR) {
                return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Component ''{0}'' behavior ''{1}'' is not transitioned in the Physical Layer", (Object)LogHelper.getInstance().getText((Object)source_p)));
            }
            if (ContextScopeHandlerHelper.getInstance((IContext)context_p).contains("SOURCE_SCOPE", source_p, context_p)) {
                return Status.OK_STATUS;
            }
            return result;
        }
    }

    public static class ToSA
    extends PhysicalComponentRule {
    }
}

