/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.compare.CapellaMatchPolicy;
import org.polarsys.capella.core.compare.CapellaScopeFactory;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFImporterDiffPolicy;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFMergePolicy;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;

public class ModelDiffTestCase
extends BasicTestCase {
    protected static final String systemAnalysis = "24658239-7734-4c39-9402-83325c52d04c";
    protected static final String inputFileName = "model/inputs/Sample.reqif";
    protected static final String projectTestName = "emptymodel";
    protected static final String projectWithImportedReqifTestName = "emptymodelWithImportedReqif";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName, projectWithImportedReqifTestName);
    }

    public void test() throws Exception {
        SessionContext session = new SessionContext(this.getSession(projectTestName));
        this.getSession(projectWithImportedReqifTestName);
        final EObject target = session.getSemanticElement(systemAnalysis);
        if (target instanceof BlockArchitecture) {
            TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    File file = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)ModelDiffTestCase.inputFileName);
                    URI model = URI.createFileURI((String)file.getPath());
                    new TestRequirementsImportLauncher().launch(model, (BlockArchitecture)target, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        CapellaModel modelWithRequif = this.getTestModel(projectWithImportedReqifTestName);
        CapellaModel testModel = this.getTestModel(projectTestName);
        IModelScopeDefinition testFixtureScopeDef = new CapellaScopeFactory().createScopeDefinition((Object)modelWithRequif.getUriSemanticFile(), "testFixtureModel", true);
        IModelScopeDefinition modelToTestScopeDef = new CapellaScopeFactory().createScopeDefinition((Object)testModel.getUriSemanticFile(), "toTestModel", true);
        IEditableTreeDataScope textFixtureScope = testFixtureScopeDef.createScope((Object)modelWithRequif.getEditingDomain());
        IEditableTreeDataScope modelToTestScope = modelToTestScopeDef.createScope((Object)testModel.getEditingDomain());
        EComparisonImpl comparison = new EComparisonImpl(textFixtureScope, modelToTestScope);
        CapellaMatchPolicy custoMatchPolicy = new CapellaMatchPolicy();
        List<ConfigurableMatchPolicy.MatchCriterionKind> criteria = Arrays.asList(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.NAME, ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE);
        custoMatchPolicy.setAllUsedCriteria(criteria);
        List<ConfigurableMatchPolicy.FineGrainedMatchCriterion> fineGrainedCriteria = Arrays.asList(ConfigurableMatchPolicy.CRITERION_QNAMES_LABELS, ConfigurableMatchPolicy.CRITERION_STRUCTURE_ROOTS, ConfigurableMatchPolicy.CRITERION_STRUCTURE_CONTAINMENTS);
        custoMatchPolicy.setAllUsedFineGrainedCriteria(fineGrainedCriteria);
        comparison.compute((IMatchPolicy)custoMatchPolicy, (IDiffPolicy)new ReqIFImporterDiffPolicy(), (IMergePolicy)new ReqIFMergePolicy(), (IProgressMonitor)new NullProgressMonitor());
        Collection differencesFromReference = comparison.getDifferences(Role.REFERENCE);
        Collection differencesFromTarget = comparison.getDifferences(Role.TARGET);
        if (differencesFromReference.size() > 0 || differencesFromTarget.size() > 0) {
            ModelDiffTestCase.fail((String)"There should not be any differences between the test model with ReqIf imported and the reference model");
        }
    }
}

