/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class HtmlToTextTestCase
extends BasicTestCase {
    private static final String projectTestName = "misc";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName);
    }

    public void test() throws Exception {
        SessionContext session = new SessionContext(this.getSession(projectTestName));
        Requirement target = (Requirement)session.getSemanticElement("130237c0-c390-4b1a-99e8-1933d14d0f21");
        this.setText(target, "value1<okok>");
        HtmlToTextTestCase.assertTrue((boolean)EObjectLabelProviderHelper.getText((Object)target).equals("value1"));
        this.setText(target, "value1<okok>\r\nvalue2");
        HtmlToTextTestCase.assertTrue((boolean)EObjectLabelProviderHelper.getText((Object)target).equals("value1 value2"));
        this.setText(target, "value1<okok>\nvalue2");
        HtmlToTextTestCase.assertTrue((boolean)EObjectLabelProviderHelper.getText((Object)target).equals("value1 value2"));
        this.setText(target, "value1<okok><pppp>\n<lll>\n</br>\r\n</kkkk>value2");
        HtmlToTextTestCase.assertTrue((boolean)EObjectLabelProviderHelper.getText((Object)target).equals("value1   value2"));
    }

    private void setText(final Requirement req, final String text) {
        TransactionHelper.getExecutionManager((EObject)req).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                req.setReqIFText(text);
            }
        });
    }
}

