/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.commandline;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.ui.AbstractWorkbenchCommandLine;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.validation.commandline.FilteringArgumentHelper;
import org.polarsys.capella.core.validation.commandline.Messages;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.tools.actions.ComposedFilteringExtractionJob;
import org.polarsys.capella.filtering.tools.actions.FilteringExtractionJob;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class DerivationCommandLine
extends AbstractWorkbenchCommandLine {
    public DerivationCommandLine() {
        this.argHelper = new FilteringArgumentHelper();
    }

    public void checkArgs(IApplicationContext context) throws CommandLineException {
        super.checkArgs(context);
        String filteringResultId = this.getArgHelper().getFilteringResultId();
        if (StringUtil.isEmpty((String)filteringResultId)) {
            this.logErrorAndThrowException(Messages.FILTERING_RESULT_ID_MANDATORY);
        }
    }

    protected IStatus executeWithinWorkbench() {
        List airdFiles;
        Set projectsFromInput = this.getProjectsFromInput();
        IProject sourceProject = (IProject)projectsFromInput.iterator().next();
        if (projectsFromInput.size() > 1) {
            this.logInfo(NLS.bind((String)Messages.MULTIPLE_INPUT_PROJECTS_DETECTED, (Object)sourceProject.getName()));
        }
        if ((airdFiles = this.getAirdFiles(sourceProject.getFullPath().toPortableString())).isEmpty()) {
            return new Status(4, "org.polarsys.capella.filtering.commandline", NLS.bind((String)Messages.PROJECT_CONTAINS_NO_AIRD, (Object)sourceProject.getName()));
        }
        IFile airdFile = (IFile)airdFiles.get(0);
        Session session = this.getSession(airdFile);
        Project rootElement = this.loadSemanticRootElement(session);
        if (rootElement == null) {
            return new Status(4, "org.polarsys.capella.filtering.commandline", Messages.NO_SEMANTIC_MODEL_FOUND);
        }
        String filteringResultId = this.getArgHelper().getFilteringResultId();
        ModelElement filteringResultCandidate = CapellaQueries.getInstance().getGetElementsQueries().getElementById(rootElement, filteringResultId);
        if (!(filteringResultCandidate instanceof AbstractFilteringResult)) {
            return new Status(4, "org.polarsys.capella.filtering.commandline", Messages.INVALID_FILTERING_RESULT_ID);
        }
        AbstractFilteringResult filteringResult = (AbstractFilteringResult)filteringResultCandidate;
        String derivedProjectName = this.computeDerivedProjectName(this.getArgHelper().getDerivationProjectName(), filteringResult.getName());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IProject targetDerivedProject = workspace.getRoot().getProject(derivedProjectName);
        try {
            targetDerivedProject.create((IProgressMonitor)progressMonitor);
            targetDerivedProject.open((IProgressMonitor)progressMonitor);
        }
        catch (CoreException e) {
            return new Status(4, "org.polarsys.capella.filtering.commandline", e.getMessage(), (Throwable)e);
        }
        FilteringCriterionSet computedFilteringCriterionSet = filteringResult.computeFilteringCriterionSet();
        EList filteringCriteria = computedFilteringCriterionSet.getFilteringCriteria();
        ComposedFilteringExtractionJob job = null;
        if (filteringResult instanceof ComposedFilteringResult) {
            job = new ComposedFilteringExtractionJob(sourceProject, targetDerivedProject, (List)filteringCriteria, filteringResult, null);
        } else if (filteringResult instanceof FilteringResult) {
            job = new FilteringExtractionJob(sourceProject, targetDerivedProject, (List)filteringCriteria, filteringResult, null);
        }
        try {
            workspace.run(job, (IProgressMonitor)progressMonitor);
        }
        catch (CoreException e) {
            return new Status(4, "org.polarsys.capella.filtering.commandline", e.getMessage(), (Throwable)e);
        }
        session.close((IProgressMonitor)progressMonitor);
        return Status.OK_STATUS;
    }

    private FilteringArgumentHelper getArgHelper() {
        return (FilteringArgumentHelper)this.argHelper;
    }

    public void printHelp() {
        List<String> hiddenArguments = Arrays.asList("-outputfolder".replace("-", ""), "-exportZip".replace("-", ""));
        super.printHelp(hiddenArguments);
        System.out.printf("%-30s%-15s%s\n", "-filteringresultid".replace("-", ""), Messages.FILTERING_RESULT_ID_CATEGORY, Messages.FILTERING_RESULT_ID_DESCRIPTION);
        System.out.printf("%-30s%-15s%s\n", "-derivationprojectname".replace("-", ""), Messages.DERIVATION_PROJECT_CATEGORY, Messages.DERIVATION_PROJECT_DESCRIPTION);
    }

    private Project loadSemanticRootElement(Session session) {
        if (!session.isOpen()) {
            session.open((IProgressMonitor)new NullProgressMonitor());
        }
        return SessionHelper.getCapellaProject((Session)session);
    }

    private Session getSession(IFile airdFile) {
        String airdFilePath = airdFile.getFullPath().toPortableString();
        URI airdFileURI = URI.createPlatformResourceURI((String)airdFilePath, (boolean)true);
        return SessionManager.INSTANCE.getSession(airdFileURI, (IProgressMonitor)new NullProgressMonitor());
    }

    private String computeDerivedProjectName(String userProvidedProjectName, String filteringResultName) {
        String derivationProjectName = "";
        if (!StringUtil.isEmpty((String)userProvidedProjectName)) {
            derivationProjectName = this.computeDerivedProjectName(userProvidedProjectName);
            if (!userProvidedProjectName.equals(derivationProjectName)) {
                this.logInfo(NLS.bind((String)Messages.DERIVATION_PROJECTS_ALREADY_EXISTS, (Object)userProvidedProjectName));
            }
        } else {
            derivationProjectName = this.computeDerivedProjectName(filteringResultName);
        }
        this.logInfo(NLS.bind((String)Messages.DERIVATION_PROJECT_COMPUTED_NAME, (Object)derivationProjectName));
        return derivationProjectName;
    }

    private String computeDerivedProjectName(String rootName) {
        String derivedProjectName = rootName;
        int i = 2;
        while (FilteringUtils.projectExists((String)derivedProjectName)) {
            derivedProjectName = String.valueOf(rootName) + "_" + i;
            ++i;
        }
        return derivedProjectName;
    }
}

