/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tools.view;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.filtering.AbstractFilteringResult;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringFactory;
import org.polarsys.capella.filtering.FilteringResult;
import org.polarsys.capella.filtering.tools.FilteringToolsPlugin;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.tools.utils.ui.CriteriaContentProvider;
import org.polarsys.capella.filtering.tools.utils.ui.FilteringResultsContentProvider;
import org.polarsys.capella.filtering.tools.view.GlobalFiteringCache;

public class DiagCriteriaVisibilityView
extends ViewPart
implements ISelectionListener {
    private static final String MESSAGE = "Diagrams reflect the filtering result";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    ICheckStateListener viewerCheckStateListener;
    ContainerCheckedTreeViewer treeViewer;
    ITreeContentProvider contentProvider = new CriteriaContentProvider();
    private Project mainProject;
    private Collection<Project> projects = null;
    private Collection<Object> checkedElements = new HashSet<Object>();
    private Collection<Object> uncheckedElements = new HashSet<Object>();
    private Collection<Object> undefinedElements = new HashSet<Object>();
    private Composite selectionButtonComposite;
    protected List<AbstractFilteringResult> filteringResults;
    private Button unchekAllButton;
    private Button checkAllButton;
    private Button refreshButton;
    private Combo filteringResultCombo;
    private Set<Control> allViewControls;
    private Set<Control> viewSubControls;
    private Label modifiedResultLabel;
    private Button enableCheckBtn;
    private Composite topControlsComposite;
    private Composite buttonComposite;

    public Collection<Object> getCheckedElements() {
        return this.checkedElements;
    }

    public void setCheckedElements(Collection<Object> checkedElements) {
        this.checkedElements = checkedElements;
    }

    public void createPartControl(Composite parent) {
        GridLayout glParent = new GridLayout(1, false);
        glParent.marginWidth = 2;
        glParent.horizontalSpacing = 2;
        glParent.verticalSpacing = 1;
        glParent.marginHeight = 1;
        parent.setLayout((Layout)glParent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 16384, true, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.topControlsComposite = new Composite(composite, 0);
        GridLayout glTopControlsComposite = new GridLayout(2, false);
        glTopControlsComposite.verticalSpacing = 2;
        this.topControlsComposite.setLayout((Layout)glTopControlsComposite);
        this.topControlsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formToolkit.createLabel(this.topControlsComposite, MESSAGE, 32);
        this.enableCheckBtn = new Button(this.topControlsComposite, 32);
        this.formToolkit.adapt((Control)this.enableCheckBtn, true, true);
        this.enableCheckBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button btn = (Button)event.getSource();
                boolean enabled = btn.getSelection();
                FilteringToolsPlugin.getGlobalFilteringCache().setEnabled(DiagCriteriaVisibilityView.this.mainProject, enabled);
                DiagCriteriaVisibilityView.this.viewSubControls.forEach(c -> c.setEnabled(enabled));
                Object input = DiagCriteriaVisibilityView.this.treeViewer.getInput();
                if (input instanceof ComposedFilteringResult) {
                    DiagCriteriaVisibilityView.this.treeViewer.getTree().setEnabled(false);
                }
                DiagCriteriaVisibilityView.this.updateCheckUncheckAllEnableState();
            }
        });
        this.viewSubControls = new HashSet<Control>();
        this.selectionButtonComposite = this.createSelectionButtonsAfterMessageArea(parent);
        new Label(this.buttonComposite, 0);
        new Label(this.buttonComposite, 0);
        new Label(this.buttonComposite, 0);
        this.allViewControls = new HashSet<Control>(this.viewSubControls);
        this.allViewControls.add((Control)this.enableCheckBtn);
        this.treeViewer = new ContainerCheckedTreeViewer(parent, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setComparator(new ViewerComparator());
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setInput(this.treeViewer.getInput());
        if (this.viewerCheckStateListener == null) {
            this.viewerCheckStateListener = this.createCheckStateListener();
        }
        this.treeViewer.addCheckStateListener(this.viewerCheckStateListener);
        this.viewSubControls.add((Control)this.treeViewer.getTree());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.createActions();
    }

    protected Composite createSelectionButtonsAfterMessageArea(Composite composite) {
        GridData data = new GridData(515);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        this.buttonComposite = new Composite(composite, 16384);
        this.buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridLayout layout = new GridLayout();
        layout.marginLeft = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 1;
        layout.verticalSpacing = 1;
        layout.numColumns = 7;
        this.buttonComposite.setLayout((Layout)layout);
        this.buttonComposite.setFont(composite.getFont());
        boolean enabledButtons = this.projects != null && !this.projects.isEmpty();
        this.createCheckAllButton(this.buttonComposite, enabledButtons);
        this.createUnchekAllButton(this.buttonComposite, enabledButtons);
        this.createRefreshButton(this.buttonComposite, enabledButtons);
        this.filteringResultCombo = new Combo(this.buttonComposite, 8);
        this.filteringResultCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.filteringResultCombo.addListener(13, this.createFilteringResultComboListener());
        this.formToolkit.createLabel(this.buttonComposite, "", 288);
        this.modifiedResultLabel = this.formToolkit.createLabel(this.buttonComposite, "", 288);
        Font result = JFaceResources.getFontRegistry().getBold(JFaceResources.getFontRegistry().defaultFont().getFontData()[0].getName());
        this.modifiedResultLabel.setFont(result);
        this.modifiedResultLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.viewSubControls.addAll(Arrays.asList(this.unchekAllButton, this.checkAllButton, this.refreshButton, this.modifiedResultLabel, this.filteringResultCombo));
        return this.buttonComposite;
    }

    private void createUnchekAllButton(Composite parent, boolean enabledButtons) {
        this.unchekAllButton = this.addButton(parent, "Uncheck All", ImageDescriptor.createFromFile(FilteringToolsPlugin.class, (String)"/icons/uncheckAll.gif").createImage(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object treeViewerInput = DiagCriteriaVisibilityView.this.treeViewer.getInput();
                Object[] objectArray = DiagCriteriaVisibilityView.this.contentProvider.getElements(treeViewerInput);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    DiagCriteriaVisibilityView.this.setTreeChecked(element, false);
                    DiagCriteriaVisibilityView.this.undefinedElements.remove(element);
                    ++n2;
                }
                if (treeViewerInput instanceof EObject) {
                    Project project = CapellaProjectHelper.getProject((EObject)((EObject)treeViewerInput));
                    FilteringToolsPlugin.getGlobalFilteringCache().remove(project);
                }
                DiagCriteriaVisibilityView.this.updateControls();
            }
        }, enabledButtons);
    }

    private void createRefreshButton(Composite parent, boolean enabledButtons) {
        this.refreshButton = this.addButton(parent, "Refresh Diagram", ImageDescriptor.createFromFile(FilteringToolsPlugin.class, (String)"/icons/refresh.gif").createImage(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagCriteriaVisibilityView.this.refreshActiveDiagram();
            }
        }, enabledButtons);
    }

    private void createCheckAllButton(Composite parent, boolean enabled) {
        this.checkAllButton = this.addButton(parent, "Check All", ImageDescriptor.createFromFile(FilteringToolsPlugin.class, (String)"/icons/checkAll.gif").createImage(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object treeViewerInput = DiagCriteriaVisibilityView.this.treeViewer.getInput();
                Object[] objectArray = DiagCriteriaVisibilityView.this.contentProvider.getElements(treeViewerInput);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    DiagCriteriaVisibilityView.this.setTreeChecked(element, true);
                    DiagCriteriaVisibilityView.this.undefinedElements.remove(element);
                    ++n2;
                }
                if (treeViewerInput instanceof EObject) {
                    Project project = CapellaProjectHelper.getProject((EObject)((EObject)treeViewerInput));
                    Collection<FilteringCriterion> allFilteringCriteria = FilteringUtils.getAllFilteringCriteria((EObject)project);
                    FilteringResult allCriteriaResult = FilteringFactory.eINSTANCE.createFilteringResult();
                    allCriteriaResult.getFilteringCriteria().addAll(allFilteringCriteria);
                    FilteringToolsPlugin.getGlobalFilteringCache().setCurrentFilteringResult(project, (AbstractFilteringResult)allCriteriaResult);
                }
                DiagCriteriaVisibilityView.this.tagModifiedResultLabel();
            }
        }, enabled);
    }

    private void createActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        Action refreshAction = new Action(null, FilteringToolsPlugin.getDefault().getImageDescriptor("refresh.gif")){

            public void run() {
                DiagCriteriaVisibilityView.this.refreshActiveDiagram();
            }
        };
        toolBarManager.add((IAction)refreshAction);
    }

    public void refreshActiveDiagram() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    if (editorPart instanceof DDiagramEditor) {
                        final DRepresentation representation = ((DDiagramEditor)editorPart).getRepresentation();
                        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)representation);
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                DialectManager.INSTANCE.refresh(representation, (IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static DDiagram getDiagram(EObject context) {
        DDiagram result = null;
        if (context instanceof DDiagram) {
            result = (DDiagram)context;
        } else if (context instanceof DDiagramElement) {
            result = ((DDiagramElement)context).getParentDiagram();
        }
        return result;
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object source = event.getSource();
                Object[] checkedElements = ((ContainerCheckedTreeViewer)source).getCheckedElements();
                List<Object> checkedList = Arrays.asList(checkedElements);
                checkedList = this.filterNonFilteringElements(checkedList);
                Object treeRoot = DiagCriteriaVisibilityView.this.treeViewer.getInput();
                if (treeRoot instanceof CapellaElement) {
                    Project project = CapellaProjectHelper.getProject((EObject)((EObject)treeRoot));
                    GlobalFiteringCache globalFilteringCache = FilteringToolsPlugin.getGlobalFilteringCache();
                    if (checkedList.isEmpty()) {
                        FilteringToolsPlugin.getGlobalFilteringCache().remove(project);
                        return;
                    }
                    Object firstElt = checkedList.get(0);
                    if (!checkedList.isEmpty()) {
                        ArrayList filCriterionToCache = new ArrayList();
                        checkedList.forEach(obj -> {
                            if (obj instanceof FilteringCriterion) {
                                filCriterionToCache.add((FilteringCriterion)obj);
                            }
                        });
                        if (filCriterionToCache.isEmpty()) {
                            FilteringToolsPlugin.getGlobalFilteringCache().remove(project);
                            return;
                        }
                        FilteringResult filtResult = FilteringFactory.eINSTANCE.createFilteringResult();
                        filtResult.getFilteringCriteria().addAll(filCriterionToCache);
                        globalFilteringCache.setCurrentFilteringResult(project, (AbstractFilteringResult)filtResult);
                        DiagCriteriaVisibilityView.this.tagModifiedResultLabel();
                    }
                    if (firstElt instanceof ComposedFilteringResult) {
                        checkedList.stream().filter(obj -> obj instanceof AbstractFilteringResult).findFirst().ifPresent(obj -> {
                            globalFilteringCache.setCurrentFilteringResult(project, (AbstractFilteringResult)obj);
                            DiagCriteriaVisibilityView.this.resetModifiedResultLabel();
                        });
                    }
                }
            }

            private List<Object> filterNonFilteringElements(List<Object> checkedList) {
                return checkedList.stream().filter(obj -> FilteringUtils.isInstanceOfFilteringExcludedElements(obj)).collect(Collectors.toList());
            }
        };
    }

    private void tagModifiedResultLabel() {
        this.setModifiedResultLabel("(MODIFIED)");
    }

    private void resetModifiedResultLabel() {
        this.setModifiedResultLabel("");
    }

    private void setModifiedResultLabel(String text) {
        this.modifiedResultLabel.setText(text);
        this.modifiedResultLabel.getParent().pack(true);
    }

    private Listener createFilteringResultComboListener() {
        return new Listener(){

            public void handleEvent(Event e) {
                DiagCriteriaVisibilityView.this.doSelectionInComboBox();
                DiagCriteriaVisibilityView.this.filteringResultCombo.pack();
                DiagCriteriaVisibilityView.this.filteringResultCombo.getParent().layout();
            }
        };
    }

    private void updateControls() {
        this.filteringResults = FilteringUtils.getFilteringResults(this.projects);
        if (this.filteringResults.isEmpty()) {
            this.filteringResultCombo.removeAll();
            this.filteringResultCombo.add("No FilteringResults");
            this.modifiedResultLabel.setData((Object)"");
            this.modifiedResultLabel.setText("");
            this.modifiedResultLabel.getParent().pack(true);
            this.treeViewer.setInput(null);
            this.viewSubControls.forEach(c -> c.setEnabled(false));
        } else {
            this.filteringResultCombo.removeAll();
            this.filteringResultCombo.add("Select a FilteringResult");
            boolean filterEnabled = FilteringToolsPlugin.getGlobalFilteringCache().isEnabled(this.mainProject);
            AbstractFilteringResult selectedFilterResult = FilteringToolsPlugin.getGlobalFilteringCache().getCurrentFilteringResult(this.mainProject);
            this.enableCheckBtn.setSelection(filterEnabled);
            int selectedFiltResultIndex = 0;
            int index = 1;
            for (AbstractFilteringResult filteringResult : this.filteringResults) {
                if (filteringResult.equals(selectedFilterResult)) {
                    selectedFiltResultIndex = index;
                }
                this.filteringResultCombo.add(FilteringUtils.formatFilteringItemName((NamedElement)filteringResult));
                ++index;
            }
            this.filteringResultCombo.select(selectedFiltResultIndex);
            this.doSelectionInComboBox();
            this.viewSubControls.forEach(c -> c.setEnabled(this.enableCheckBtn.getSelection()));
        }
        this.filteringResultCombo.pack();
        this.updateTreeViewerEnableState();
        this.updateCheckUncheckAllEnableState();
    }

    private void updateTreeViewerEnableState() {
        Object input = this.treeViewer.getInput();
        this.treeViewer.refresh();
        this.treeViewer.getTree().setEnabled(!(input instanceof ComposedFilteringResult));
    }

    private void updateCheckUncheckAllEnableState() {
        Object input = this.treeViewer.getInput();
        if (input instanceof ComposedFilteringResult) {
            this.checkAllButton.setEnabled(false);
            this.unchekAllButton.setEnabled(false);
        }
        if (input instanceof SystemEngineering) {
            this.checkAllButton.setEnabled(true);
            this.unchekAllButton.setEnabled(true);
        }
    }

    private Button addButton(Composite parent, String toolTipText, Image image, SelectionListener action, boolean enabled) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setImage(image);
        button.addSelectionListener(action);
        button.setEnabled(enabled);
        return button;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.projects = null;
        this.mainProject = null;
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            EObject selectedEObject = null;
            if (firstElement instanceof DiagramEditPart) {
                selectedEObject = ((DiagramEditPart)firstElement).resolveSemanticElement();
            } else if (firstElement instanceof EObject) {
                selectedEObject = (EObject)firstElement;
            }
            this.handleSelection(selectedEObject);
            this.updateControls();
        }
    }

    private void handleSelection(EObject eObject) {
        if (eObject instanceof DSemanticDecorator) {
            eObject = ((DSemanticDecorator)eObject).getTarget();
        }
        if (eObject instanceof DRepresentationDescriptor) {
            eObject = ((DRepresentationDescriptor)eObject).getTarget();
        }
        this.focusOn(eObject);
        if (eObject != null) {
            this.mainProject = CapellaProjectHelper.getProject((EObject)eObject);
            this.projects = FilteringUtils.getMainAndReferencedVariantProjects(eObject);
        }
    }

    private void focusOn(EObject eObj) {
        Session session;
        if (eObj == null) {
            this.treeViewer.setInput(null);
        }
        if ((session = SessionManager.INSTANCE.getSession(eObj)) != null) {
            TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
            TransactionalAdapterFactoryLabelProvider labelProvider = new TransactionalAdapterFactoryLabelProvider(transactionalEditingDomain, ((AdapterFactoryEditingDomain)transactionalEditingDomain).getAdapterFactory());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.treeViewer.setInput((Object)FilteringUtils.getSystemEngineering(eObj));
        }
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        this.treeViewer.setChecked(treeElement, state);
        this.treeViewer.setGrayed(treeElement, false);
        this.updateCheckUncheckedElements(treeElement, state);
        if (this.contentProvider.hasChildren(treeElement)) {
            Object[] children = this.contentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                this.setTreeChecked(children[i], state);
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        FilteringToolsPlugin.getGlobalFilteringCache().clear();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected void updateCheckUncheckedElements(Object element, boolean state) {
        if (state) {
            this.checkedElements.add(element);
            this.uncheckedElements.remove(element);
        } else {
            this.checkedElements.remove(element);
            this.uncheckedElements.add(element);
        }
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        this.updateCheckUncheckedElements(treeElement, state);
        this.setTreeChecked(treeElement, state);
        Object parent = this.contentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.grayUpdateHierarchy(parent);
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedElements.remove(treeElement);
            this.uncheckedElements.add(treeElement);
        }
        if ((parent = this.contentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        if (this.contentProvider.hasChildren(treeElement)) {
            Object[] children = this.contentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                if (this.checkedElements.contains(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void grayUpdateHierarchy(Object treeElement) {
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.updateCheckUncheckedElements(treeElement, shouldBeAtLeastGray);
        this.treeViewer.setGrayChecked(treeElement, shouldBeAtLeastGray);
        Object parent = this.contentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayUpdateHierarchy(parent);
        }
    }

    protected void grayCheckHierarchy(Object treeElement) {
        if (this.checkedElements.contains(treeElement)) {
            return;
        }
        Object parent = this.contentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    private void doSelectionInComboBox() {
        if (this.filteringResultCombo.getSelectionIndex() == 0) {
            this.resetModifiedResultLabel();
            return;
        }
        int realIndex = this.filteringResultCombo.getSelectionIndex() - 1;
        AbstractFilteringResult filteringResult = this.filteringResults.get(realIndex);
        Project project = CapellaProjectHelper.getProject((EObject)filteringResult);
        FilteringToolsPlugin.getGlobalFilteringCache().setCurrentFilteringResult(project, filteringResult);
        if (filteringResult instanceof FilteringResult) {
            this.contentProvider = new CriteriaContentProvider();
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.treeViewer.setInput((Object)FilteringUtils.getSystemEngineering((EObject)filteringResult));
            this.uncheckedElements.clear();
            this.checkedElements.clear();
            this.updateTreeViewerEnableState();
            this.updateCheckUncheckAllEnableState();
        }
        if (filteringResult instanceof ComposedFilteringResult) {
            this.contentProvider = new FilteringResultsContentProvider();
            this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.treeViewer.setInput((Object)filteringResult);
            this.uncheckedElements.clear();
            this.checkedElements.clear();
            this.updateTreeViewerEnableState();
            this.updateCheckUncheckAllEnableState();
        }
        Object[] objectArray = this.contentProvider.getElements(this.projects);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.treeItemChecked(element, false);
            ++n2;
        }
        for (FilteringCriterion vf : filteringResult.computeFilteringCriterionSet().getFilteringCriteria()) {
            this.treeItemChecked(vf, true);
            this.undefinedElements.remove(vf);
        }
        this.resetModifiedResultLabel();
    }

    public void setFocus() {
    }
}

