/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.ComposedFilteringResult;
import org.polarsys.capella.filtering.ExclusionFilteringResultSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringFactory;
import org.polarsys.capella.filtering.FilteringPackage;
import org.polarsys.capella.filtering.IntersectionFilteringResultSet;
import org.polarsys.capella.filtering.UnionFilteringResultSet;
import org.polarsys.capella.filtering.impl.AbstractFilteringResultImpl;
import org.polarsys.capella.filtering.model.helpers.FilteringCriterionSetHelper;

public class ComposedFilteringResultImpl
extends AbstractFilteringResultImpl
implements ComposedFilteringResult {
    protected UnionFilteringResultSet unionFilteringResultSet;
    protected IntersectionFilteringResultSet intersectionFilteringResultSet;
    protected ExclusionFilteringResultSet exclusionFilteringResultSet;

    protected ComposedFilteringResultImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return FilteringPackage.Literals.COMPOSED_FILTERING_RESULT;
    }

    @Override
    public FilteringCriterionSet computeFilteringCriterionSet() {
        EList<FilteringCriterion> unionOfAll;
        FilteringCriterionSet unionFResult = null;
        FilteringCriterionSet intersectionFResult = null;
        FilteringCriterionSet excludingCriterionSet = null;
        AssociatedFilteringCriterionSet computedCriterionSet = null;
        if (this.unionFilteringResultSet != null) {
            Stream<FilteringCriterionSet> unionFResultStm = this.unionFilteringResultSet.getFilteringResults().stream().map(afResult -> afResult.computeFilteringCriterionSet());
            unionFResult = FilteringCriterionSetHelper.unionOf(unionFResultStm.collect(Collectors.toList()));
        }
        if (this.intersectionFilteringResultSet != null) {
            Stream<FilteringCriterionSet> intersectionFResultStm = this.intersectionFilteringResultSet.getFilteringResults().stream().map(afResult -> afResult.computeFilteringCriterionSet());
            intersectionFResult = FilteringCriterionSetHelper.unionOf(intersectionFResultStm.collect(Collectors.toSet()));
        }
        if (this.exclusionFilteringResultSet != null) {
            List<FilteringCriterionSet> exclusionCriterionSets = this.exclusionFilteringResultSet.getFilteringResults().stream().map(afResult -> afResult.computeFilteringCriterionSet()).collect(Collectors.toList());
            excludingCriterionSet = FilteringCriterionSetHelper.unionOf(exclusionCriterionSets);
        }
        if ((unionOfAll = FilteringCriterionSetHelper.unionOf(unionFResult, intersectionFResult, excludingCriterionSet).getFilteringCriteria()) != null) {
            computedCriterionSet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
            computedCriterionSet.getFilteringCriteria().addAll(unionOfAll);
        }
        return computedCriterionSet;
    }

    @Override
    public UnionFilteringResultSet getUnionFilteringResultSet() {
        return this.unionFilteringResultSet;
    }

    public NotificationChain basicSetUnionFilteringResultSet(UnionFilteringResultSet newUnionFilteringResultSet, NotificationChain msgs) {
        UnionFilteringResultSet oldUnionFilteringResultSet = this.unionFilteringResultSet;
        this.unionFilteringResultSet = newUnionFilteringResultSet;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 21, (Object)oldUnionFilteringResultSet, (Object)newUnionFilteringResultSet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setUnionFilteringResultSet(UnionFilteringResultSet newUnionFilteringResultSet) {
        if (newUnionFilteringResultSet != this.unionFilteringResultSet) {
            NotificationChain msgs = null;
            if (this.unionFilteringResultSet != null) {
                msgs = ((InternalEObject)this.unionFilteringResultSet).eInverseRemove((InternalEObject)this, -22, null, msgs);
            }
            if (newUnionFilteringResultSet != null) {
                msgs = ((InternalEObject)newUnionFilteringResultSet).eInverseAdd((InternalEObject)this, -22, null, msgs);
            }
            if ((msgs = this.basicSetUnionFilteringResultSet(newUnionFilteringResultSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, (Object)newUnionFilteringResultSet, (Object)newUnionFilteringResultSet));
        }
    }

    @Override
    public IntersectionFilteringResultSet getIntersectionFilteringResultSet() {
        return this.intersectionFilteringResultSet;
    }

    public NotificationChain basicSetIntersectionFilteringResultSet(IntersectionFilteringResultSet newIntersectionFilteringResultSet, NotificationChain msgs) {
        IntersectionFilteringResultSet oldIntersectionFilteringResultSet = this.intersectionFilteringResultSet;
        this.intersectionFilteringResultSet = newIntersectionFilteringResultSet;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 22, (Object)oldIntersectionFilteringResultSet, (Object)newIntersectionFilteringResultSet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setIntersectionFilteringResultSet(IntersectionFilteringResultSet newIntersectionFilteringResultSet) {
        if (newIntersectionFilteringResultSet != this.intersectionFilteringResultSet) {
            NotificationChain msgs = null;
            if (this.intersectionFilteringResultSet != null) {
                msgs = ((InternalEObject)this.intersectionFilteringResultSet).eInverseRemove((InternalEObject)this, -23, null, msgs);
            }
            if (newIntersectionFilteringResultSet != null) {
                msgs = ((InternalEObject)newIntersectionFilteringResultSet).eInverseAdd((InternalEObject)this, -23, null, msgs);
            }
            if ((msgs = this.basicSetIntersectionFilteringResultSet(newIntersectionFilteringResultSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 22, (Object)newIntersectionFilteringResultSet, (Object)newIntersectionFilteringResultSet));
        }
    }

    @Override
    public ExclusionFilteringResultSet getExclusionFilteringResultSet() {
        return this.exclusionFilteringResultSet;
    }

    public NotificationChain basicSetExclusionFilteringResultSet(ExclusionFilteringResultSet newExclusionFilteringResultSet, NotificationChain msgs) {
        ExclusionFilteringResultSet oldExclusionFilteringResultSet = this.exclusionFilteringResultSet;
        this.exclusionFilteringResultSet = newExclusionFilteringResultSet;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 23, (Object)oldExclusionFilteringResultSet, (Object)newExclusionFilteringResultSet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setExclusionFilteringResultSet(ExclusionFilteringResultSet newExclusionFilteringResultSet) {
        if (newExclusionFilteringResultSet != this.exclusionFilteringResultSet) {
            NotificationChain msgs = null;
            if (this.exclusionFilteringResultSet != null) {
                msgs = ((InternalEObject)this.exclusionFilteringResultSet).eInverseRemove((InternalEObject)this, -24, null, msgs);
            }
            if (newExclusionFilteringResultSet != null) {
                msgs = ((InternalEObject)newExclusionFilteringResultSet).eInverseAdd((InternalEObject)this, -24, null, msgs);
            }
            if ((msgs = this.basicSetExclusionFilteringResultSet(newExclusionFilteringResultSet, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 23, (Object)newExclusionFilteringResultSet, (Object)newExclusionFilteringResultSet));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 21: {
                return this.basicSetUnionFilteringResultSet(null, msgs);
            }
            case 22: {
                return this.basicSetIntersectionFilteringResultSet(null, msgs);
            }
            case 23: {
                return this.basicSetExclusionFilteringResultSet(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 21: {
                return this.getUnionFilteringResultSet();
            }
            case 22: {
                return this.getIntersectionFilteringResultSet();
            }
            case 23: {
                return this.getExclusionFilteringResultSet();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 21: {
                this.setUnionFilteringResultSet((UnionFilteringResultSet)newValue);
                return;
            }
            case 22: {
                this.setIntersectionFilteringResultSet((IntersectionFilteringResultSet)newValue);
                return;
            }
            case 23: {
                this.setExclusionFilteringResultSet((ExclusionFilteringResultSet)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 21: {
                this.setUnionFilteringResultSet(null);
                return;
            }
            case 22: {
                this.setIntersectionFilteringResultSet(null);
                return;
            }
            case 23: {
                this.setExclusionFilteringResultSet(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 21: {
                return this.unionFilteringResultSet != null;
            }
            case 22: {
                return this.intersectionFilteringResultSet != null;
            }
            case 23: {
                return this.exclusionFilteringResultSet != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

