/*******************************************************************************
 * Copyright (c) 2019 THALES GLOBAL SERVICES.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *   
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/

package org.polarsys.capella.cybersecurity.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.util.CybersecurityAdapterFactory;
import org.polarsys.kitalpha.emde.extension.ModelExtensionHelper;
import org.polarsys.kitalpha.emde.extension.edit.ChildCreationExtenderManager;
import org.polarsys.kitalpha.emde.model.EmdePackage;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;
import org.polarsys.kitalpha.emde.model.edit.provider.NewChildDescriptorHelper;
import org.polarsys.kitalpha.emde.model.util.EmdeSwitch;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The adapters generated by this
 * factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}. The adapters
 * also support Eclipse property sheets. Note that most of the adapters are shared among multiple instances. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class CybersecurityItemProviderAdapterFactory extends CybersecurityAdapterFactory
    implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This helps manage the child creation extenders.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
      CybersecurityEditPlugin.INSTANCE, CybersecurityPackage.eNS_URI);

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public CybersecurityItemProviderAdapterFactory() {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.CybersecurityPkg} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected CybersecurityPkgItemProvider cybersecurityPkgItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.CybersecurityPkg}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createCybersecurityPkgAdapter() {
    if (cybersecurityPkgItemProvider == null) {
      cybersecurityPkgItemProvider = new CybersecurityPkgItemProvider(this);
    }

    return cybersecurityPkgItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.Threat} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected ThreatItemProvider threatItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.Threat}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createThreatAdapter() {
    if (threatItemProvider == null) {
      threatItemProvider = new ThreatItemProvider(this);
    }

    return threatItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.ThreatInvolvement} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected ThreatInvolvementItemProvider threatInvolvementItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.ThreatInvolvement}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createThreatInvolvementAdapter() {
    if (threatInvolvementItemProvider == null) {
      threatInvolvementItemProvider = new ThreatInvolvementItemProvider(this);
    }

    return threatInvolvementItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.FunctionStorage} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected FunctionStorageItemProvider functionStorageItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.FunctionStorage}.
   * <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createFunctionStorageAdapter() {
    if (functionStorageItemProvider == null) {
      functionStorageItemProvider = new FunctionStorageItemProvider(this);
    }

    return functionStorageItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.ThreatApplication} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected ThreatApplicationItemProvider threatApplicationItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.ThreatApplication}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createThreatApplicationAdapter() {
    if (threatApplicationItemProvider == null) {
      threatApplicationItemProvider = new ThreatApplicationItemProvider(this);
    }

    return threatApplicationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.PrimaryAssetStorage} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected PrimaryAssetStorageItemProvider primaryAssetStorageItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.PrimaryAssetStorage}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createPrimaryAssetStorageAdapter() {
    if (primaryAssetStorageItemProvider == null) {
      primaryAssetStorageItemProvider = new PrimaryAssetStorageItemProvider(this);
    }

    return primaryAssetStorageItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.SecurityNeeds} instances.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  protected SecurityNeedsItemProvider securityNeedsItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.SecurityNeeds}.
   * <!-- begin-user-doc
   * --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createSecurityNeedsAdapter() {
    if (securityNeedsItemProvider == null) {
      securityNeedsItemProvider = new SecurityNeedsItemProvider(this);
    }

    return securityNeedsItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected TrustBoundaryStorageItemProvider trustBoundaryStorageItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createTrustBoundaryStorageAdapter() {
    if (trustBoundaryStorageItemProvider == null) {
      trustBoundaryStorageItemProvider = new TrustBoundaryStorageItemProvider(this);
    }

    return trustBoundaryStorageItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected FunctionalPrimaryAssetItemProvider functionalPrimaryAssetItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createFunctionalPrimaryAssetAdapter() {
    if (functionalPrimaryAssetItemProvider == null) {
      functionalPrimaryAssetItemProvider = new FunctionalPrimaryAssetItemProvider(this);
    }

    return functionalPrimaryAssetItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected InformationPrimaryAssetItemProvider informationPrimaryAssetItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createInformationPrimaryAssetAdapter() {
    if (informationPrimaryAssetItemProvider == null) {
      informationPrimaryAssetItemProvider = new InformationPrimaryAssetItemProvider(this);
    }

    return informationPrimaryAssetItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.PrimaryAssetMember} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected PrimaryAssetMemberItemProvider primaryAssetMemberItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.PrimaryAssetMember}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createPrimaryAssetMemberAdapter() {
    if (primaryAssetMemberItemProvider == null) {
      primaryAssetMemberItemProvider = new PrimaryAssetMemberItemProvider(this);
    }

    return primaryAssetMemberItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected CybersecurityConfigurationItemProvider cybersecurityConfigurationItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createCybersecurityConfigurationAdapter() {
    if (cybersecurityConfigurationItemProvider == null) {
      cybersecurityConfigurationItemProvider = new CybersecurityConfigurationItemProvider(this);
    }

    return cybersecurityConfigurationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset} instances.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  protected EnterprisePrimaryAssetItemProvider enterprisePrimaryAssetItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset}. <!--
   * begin-user-doc --> <!-- end-user-doc -->
   * 
   * @generated
   */
  @Override
  public Adapter createEnterprisePrimaryAssetAdapter() {
    if (enterprisePrimaryAssetItemProvider == null) {
      enterprisePrimaryAssetItemProvider = new EnterprisePrimaryAssetItemProvider(this);
    }

    return enterprisePrimaryAssetItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.cybersecurity.model.ThreatSourceUse} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ThreatSourceUseItemProvider threatSourceUseItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.cybersecurity.model.ThreatSourceUse}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createThreatSourceUseAdapter() {
    if (threatSourceUseItemProvider == null) {
      threatSourceUseItemProvider = new ThreatSourceUseItemProvider(this);
    }

    return threatSourceUseItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ComposeableAdapterFactory getRootAdapterFactory() {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object type) {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type) {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type) {
    if (isFactoryForType(type)) {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
        return adapter;
      }
    }

    return null;
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public List<IChildCreationExtender> getChildCreationExtenders() {
    return childCreationExtenderManager.getChildCreationExtenders();
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
    return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
  }

  /**
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public ResourceLocator getResourceLocator() {
    return childCreationExtenderManager;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void addListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void removeListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc --> <!--
   * end-user-doc -->
   * @generated
   */
  @Override
  public void fireNotifyChanged(Notification notification) {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null) {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory. 
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void dispose() {
    if (cybersecurityPkgItemProvider != null)
      cybersecurityPkgItemProvider.dispose();
    if (threatItemProvider != null)
      threatItemProvider.dispose();
    if (threatInvolvementItemProvider != null)
      threatInvolvementItemProvider.dispose();
    if (functionStorageItemProvider != null)
      functionStorageItemProvider.dispose();
    if (threatApplicationItemProvider != null)
      threatApplicationItemProvider.dispose();
    if (primaryAssetStorageItemProvider != null)
      primaryAssetStorageItemProvider.dispose();
    if (securityNeedsItemProvider != null)
      securityNeedsItemProvider.dispose();
    if (trustBoundaryStorageItemProvider != null)
      trustBoundaryStorageItemProvider.dispose();
    if (functionalPrimaryAssetItemProvider != null)
      functionalPrimaryAssetItemProvider.dispose();
    if (informationPrimaryAssetItemProvider != null)
      informationPrimaryAssetItemProvider.dispose();
    if (primaryAssetMemberItemProvider != null)
      primaryAssetMemberItemProvider.dispose();
    if (cybersecurityConfigurationItemProvider != null)
      cybersecurityConfigurationItemProvider.dispose();
    if (enterprisePrimaryAssetItemProvider != null)
      enterprisePrimaryAssetItemProvider.dispose();
    if (threatSourceUseItemProvider != null)
      threatSourceUseItemProvider.dispose();
  }

  /**
   * A child creation extender for the {@link EmdePackage}.
   * <!-- begin-user-doc --> <!-- end-user-doc -->
   * @generated
   */
  public static class EmdeChildCreationExtender implements IChildCreationExtender {
    /**
     * The switch for creating child descriptors specific to each extended class.
     * <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * @generated
     */
    protected static class CreationSwitch extends EmdeSwitch<Object> {
      /**
       * The child descriptors being populated.
       * <!-- begin-user-doc --> <!-- end-user-doc -->
       * @generated
       */
      protected List<Object> newChildDescriptors;

      /**
       * The domain in which to create the children.
       * <!-- begin-user-doc --> <!-- end-user-doc -->
       * @generated
       */
      protected EditingDomain editingDomain;

      /**
       * Creates the a switch for populating child descriptors in the given domain.
       * <!-- begin-user-doc --> <!--
       * end-user-doc -->
       * @generated
       */
      CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
        this.newChildDescriptors = newChildDescriptors;
        this.editingDomain = editingDomain;
      }

      /**
       * <!-- begin-user-doc --> <!-- end-user-doc -->
       * @generated
       */
      @Override
      public Object caseExtensibleElement(ExtensibleElement object) {
        // begin-extension-code
        if (ModelExtensionHelper.getInstance(object).isExtensionModelDisabled(
            EcoreUtil.getRootContainer(object).eClass().getEPackage().getNsURI(),
            "http://www.polarsys.org/capella/cybersecurity/1.0")) { //$NON-NLS-1$
          return null;
        }
        // end-extension-code
        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createCybersecurityPkg());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createThreatInvolvement());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createFunctionStorage());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createThreatApplication());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createPrimaryAssetStorage());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createSecurityNeeds());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createCybersecurityConfiguration());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        // begin-extension-code
        {
          CommandParameter commandParameter = createChildParameter(
              EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS,
              CybersecurityFactory.eINSTANCE.createThreatSourceUse());
          if (NewChildDescriptorHelper.isValidCommand(object, commandParameter)) {
            newChildDescriptors.add(commandParameter);
          }
        }
        // end-extension-code

        return null;
      }

      /**
       * <!-- begin-user-doc --> <!-- end-user-doc -->
       * @generated
       */
      protected CommandParameter createChildParameter(Object feature, Object child) {
        return new CommandParameter(null, feature, child);
      }

    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
      ArrayList<Object> result = new ArrayList<Object>();
      new CreationSwitch(result, editingDomain).doSwitch((EObject) object);
      return result;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * @generated
     */
    public ResourceLocator getResourceLocator() {
      return CybersecurityEditPlugin.INSTANCE;
    }
  }

}