/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.activity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.explorer.activity.ui.hyperlinkadapter.ModelCreationHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.ui.toolkit.helpers.SelectionDialogHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;

public class ScenarioCreationHelper {
    public static AbstractCapability selectCapability(Project project, BlockArchitecture architecture) {
        final AbstractCapability[] result = new AbstractCapability[1];
        List<EObject> all = ScenarioCreationHelper.getAllAbstractCapabitilies(project, architecture);
        final AbstractCapabilityPkg capabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture);
        if (capabilityPkg != null) {
            if (!all.isEmpty()) {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                result[0] = (AbstractCapability)SelectionDialogHelper.simplePropertySelectionDialogWizard(new ArrayList<EObject>(all), (Shell)shell);
                return result[0];
            }
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                public void run() {
                    result[0] = ModelCreationHelper.createAbstractCapability((AbstractCapabilityPkg)capabilityPkg);
                }
            };
            TransactionHelper.getExecutionManager((EObject)project).execute((ICommand)cmd);
        }
        return result[0];
    }

    public static List<EObject> getAllAbstractCapabitilies(Project project, BlockArchitecture architecture) {
        AbstractCapabilityPkg capabilityPkg;
        ArrayList<EObject> result = new ArrayList<EObject>();
        CybersecurityPkg cyberPkg = new CybersecurityServices().getDefaultCyberSecurityPackage((EObject)architecture, false);
        if (cyberPkg != null) {
            result.addAll((Collection<EObject>)cyberPkg.getOwnedThreats());
        }
        if ((capabilityPkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)architecture)) != null) {
            EClass clazz = CtxPackage.Literals.CAPABILITY;
            if (capabilityPkg instanceof CapabilityRealizationPkg) {
                clazz = LaPackage.Literals.CAPABILITY_REALIZATION;
            } else if (capabilityPkg instanceof OperationalCapabilityPkg) {
                clazz = OaPackage.Literals.OPERATIONAL_CAPABILITY;
            }
            result.addAll(EObjectExt.getAll((EObject)capabilityPkg, (EClass)clazz));
        }
        return result;
    }
}

